/*
 * Decompiled with CFR 0.152.
 */
package de.perview.sp;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.springframework.stereotype.Component;

@Component
public class CommonUtils {
    public String pretty(Object object) {
        return this.pretty(object, false);
    }

    public String pretty(Object object, boolean throwException) {
        String json;
        block3: {
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(SerializationFeature.INDENT_OUTPUT);
            mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
            mapper.setTimeZone(TimeZone.getTimeZone("Europe/Berlin"));
            json = "null";
            if (object != null) {
                try {
                    json = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
                }
                catch (JsonProcessingException e) {
                    json = object.toString();
                    if (!throwException) break block3;
                    throw new RuntimeException("Cannot generate Json: object=" + json, e);
                }
            }
        }
        return "\n" + json;
    }

    public Date getDate(String dateString, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.GERMANY);
        try {
            return formatter.parse(dateString);
        }
        catch (ParseException e) {
            throw new RuntimeException("Cannot parse date string: " + dateString + ", format=" + format, e);
        }
    }

    public String getFormattedDate(Date date, String format) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(date);
    }

    public String getElapsedTime(long startMillis) {
        long difference = System.currentTimeMillis() - startMillis;
        Duration duration = Duration.ofMillis(difference);
        long HH = duration.toHours();
        long MM = duration.toMinutesPart();
        long SS = duration.toSecondsPart();
        return String.format("%02d:%02d:%02d HH:MM:SS", HH, MM, SS);
    }

    public String getExceptionDetails(Throwable throwable) {
        ArrayList<String> result = new ArrayList<String>();
        String info = throwable.getClass().getSimpleName() + ": " + throwable.getLocalizedMessage();
        result.add(info);
        for (throwable = throwable.getCause(); throwable != null; throwable = throwable.getCause()) {
            info = "\ncause=" + throwable.getClass().getSimpleName() + ": " + throwable.getLocalizedMessage();
            result.add(info);
        }
        return ((Object)result).toString();
    }

    public String getExceptionCause(Throwable throwable) {
        String info = throwable.getClass().getSimpleName() + ": " + throwable.getLocalizedMessage();
        for (throwable = throwable.getCause(); throwable != null; throwable = throwable.getCause()) {
            info = throwable.getClass().getSimpleName() + ": " + throwable.getLocalizedMessage();
        }
        return info;
    }
}

