/*
 * Decompiled with CFR 0.152.
 */
package de.perview.sp.api;

import de.perview.sp.api.PersonIdentityDto;
import de.perview.sp.api.PersonUpdatedFieldDto;
import de.perview.sp.api.PerviewApiConfiguration;
import de.perview.sp.dto.PersonDto;
import de.perview.sp.dto.PersonValidFromDto;
import java.util.Date;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="personsStore", url="${perview.api.url}", configuration={PerviewApiConfiguration.class})
public interface PerviewApi {
    @GetMapping(value={"${perview.api.path.persons}"})
    public List<PersonDto> getPerviewPersonsPaged(@RequestParam(value="filter_by") String var1, @RequestParam(value="page") Integer var2, @RequestParam(value="per_page") Integer var3, @RequestParam(value="order_by") String var4);

    @PostMapping(value={"${perview.api.path.persons.validfrom}"})
    public PersonValidFromDto getPersonValidFrom(@RequestBody PersonValidFromDto var1);

    @PostMapping(value={"${perview.api.path.persons}"})
    public ResponseEntity<PersonDto> postPerviewPerson(@RequestBody PersonDto var1);

    @PostMapping(value={"${perview.api.path.persons}"})
    public ResponseEntity<PersonDto> sync(PersonDto var1, @RequestParam(name="identifyByIdentcode") Boolean var2);

    @GetMapping(value={"${perview.api.persons.updated}"})
    public List<PersonUpdatedFieldDto> getPersonsUpdatedFields(@RequestParam(value="since") @DateTimeFormat(pattern="yyyy-MM-dd_HH:mm:ss") Date var1, @RequestParam(value="until") @DateTimeFormat(pattern="yyyy-MM-dd_HH:mm:ss") Date var2);

    @GetMapping(value={"${perview.api.persons.updated}"})
    public List<PersonUpdatedFieldDto> getPersonsUpdatedFields(@RequestParam(value="id") String var1, @RequestParam(value="since") @DateTimeFormat(pattern="yyyy-MM-dd_HH:mm:ss") Date var2, @RequestParam(value="until") @DateTimeFormat(pattern="yyyy-MM-dd_HH:mm:ss") Date var3);

    @GetMapping(value={"${perview.api.persons.created}"})
    public List<PersonIdentityDto> getCreatedPersons(@RequestParam(value="since") @DateTimeFormat(pattern="yyyy-MM-dd_HH:mm:ss") Date var1, @RequestParam(value="until") @DateTimeFormat(pattern="yyyy-MM-dd_HH:mm:ss") Date var2);
}

