/*
 * Decompiled with CFR 0.152.
 */
package de.perview.sp.api;

import de.perview.sp.api.SPDataReadApi;
import de.perview.sp.dto.PersonDto;
import de.perview.sp.schedulers.SPDataUtils;
import feign.FeignException;
import generated.Mitarbeiter.Daten;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class SPDataApiClient {
    private static final Logger LOG = LoggerFactory.getLogger(SPDataApiClient.class);
    @Autowired
    private SPDataReadApi spDataReadApi;

    public Daten.Mitarbeiter fetchSpDataMitarbeiterBySyncid(PersonDto perviewPerson) {
        String syncid = perviewPerson.getSyncId();
        if (!StringUtils.hasText((String)syncid)) {
            LOG.warn("Person has no syncid: " + perviewPerson.getNameAndAllIds());
            return null;
        }
        LOG.info("fetchSpDataMitarbeiterBySyncid: perviewperson=" + perviewPerson.getNameAndIds() + ", syncid=" + syncid);
        try {
            List employees = this.spDataReadApi.getMitarbeiterBySyncid(syncid).getMitarbeiter();
            LOG.debug("getMitarbeiterBySyncid: Retrieved employees=" + employees.size());
            if (employees.isEmpty()) {
                return null;
            }
            LOG.debug("fetchSpDataMitarbeiterBySyncid: mitarbeiter[0]=" + SPDataUtils.getAsString((Daten.Mitarbeiter)((Daten.Mitarbeiter)employees.get(0))));
            return (Daten.Mitarbeiter)employees.get(0);
        }
        catch (FeignException e) {
            int status = e.status();
            if (status == 404) {
                LOG.debug("getMitarbeiterBySyncid: Returned status: 404 (Not found)");
                return null;
            }
            LOG.error("getMitarbeiterBySyncid: Returned status: " + status);
            throw new RuntimeException("Fetching Mitarbeiter failed: perviewPerson=" + perviewPerson.getNameAndAllIds() + ", syncid=" + syncid, e);
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching Mitarbeiter failed: perviewPerson=" + perviewPerson.getNameAndAllIds() + ", syncid=" + syncid, e);
        }
    }
}

