/*
 * Decompiled with CFR 0.152.
 */
package de.perview.sp.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import de.perview.sp.dto.AddressDto;
import de.perview.sp.dto.Denomination;
import de.perview.sp.dto.MaritalStatus;
import de.perview.sp.dto.Sex;
import de.perview.sp.dto.TaxBrackets;
import de.perview.sp.schedulers.SPDataUtils;
import generated.Mitarbeiter.AdresseTyp;
import generated.Mitarbeiter.Daten;
import generated.Mitarbeiter.GeschlechtTyp;
import generated.Mitarbeiter.MandantTyp;
import generated.Mitarbeiter.NachweisBehinderungTyp;
import generated.Mitarbeiter.UrlaubskontoBuchungTyp;
import generated.Mitarbeiter.ZeitraumListeTyp;
import generated.Mitarbeiter.ZeitraumTyp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.springframework.util.StringUtils;

public class PersonDto
implements Comparable<PersonDto> {
    public static String customFieldKeySyncId = "";
    public static String customFieldKeyMandantennummer = "";
    public static String customFieldKeyMandantenId = "";
    public static String defaultCompany = "";
    public static SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
    private String id;
    private String lastname;
    private String firstname;
    private Sex sex = Sex.UNKNOWN;
    private String title;
    private AddressDto privateAddress;
    private Double childAllowance;
    private String nameAtBirth;
    private String placeOfBirth;
    @JsonFormat(pattern="yyyy-MM-dd")
    private Date birthdate;
    private String ssn;
    private String phone;
    private String privPhone;
    private String fax;
    private String privFax;
    private String email;
    private String privEmail;
    private String mobile;
    private String privMobile;
    private String location;
    @JsonFormat(pattern="yyyy-MM-dd")
    private Date retirementDate;
    private String bankAccountIban;
    private String bankAccountBic;
    private String bankAccountBankName;
    private List<String> wageTypes = new ArrayList();
    private String hierarchyitem;
    private Double workingHoursPerWeek;
    private Integer vacationDays;
    private String nationality;
    private String taxNumber;
    private TaxBrackets taxBracket;
    private Integer numberOfChildrens;
    private MaritalStatus maritalStatus;
    private List<String> disabilities = new ArrayList();
    private List<Integer> disabilityWeights = new ArrayList();
    private String identcode;
    private Denomination denomination;
    @JsonFormat(pattern="yyyy-MM-dd")
    private Date entrydate;
    @JsonFormat(pattern="yyyy-MM-dd")
    private Date exitdate;
    private List<String> costCenters = new ArrayList();
    private List<Integer> costCenterWeights = new ArrayList();
    private SortedMap<String, String> customFields = new TreeMap();
    private String company;

    public PersonDto() {
    }

    public PersonDto(Daten.Mitarbeiter m) {
        this.setId(m.getSyncid());
        if (defaultCompany != null && !defaultCompany.isEmpty()) {
            this.setCompany(defaultCompany);
        }
        this.copyProperties(m);
    }

    private void copyProperties(Daten.Mitarbeiter m) {
        MandantTyp typ;
        AdresseTyp a;
        this.setIdentcode(m.getPersonalnr());
        this.setFirstname(this.trim(m.getVorname()));
        this.setLastname(this.trim(m.getNachname()));
        this.setTitle(this.trim(m.getTitel()));
        this.setSyncId(m.getSyncid());
        this.setSex(SPDataUtils.getSexFromGeschlechtTyp((GeschlechtTyp)m.getGeschlecht()));
        if (m.getAdressen() != null && !m.getAdressen().getAdresse().isEmpty() && (a = SPDataUtils.getCurrentAddress((Daten.Mitarbeiter)m)) != null) {
            this.setPrivateAddress(new AddressDto(a));
        }
        if (m.getGehaltskonto() != null) {
            this.setBankAccountBankName(this.trim(m.getGehaltskonto().getBankname()));
            this.setBankAccountIban(this.trim(m.getGehaltskonto().getIban()));
            this.setBankAccountBic(this.trim(m.getGehaltskonto().getBic()));
        }
        if (m.getNachweisbehinderungen() != null && !m.getNachweisbehinderungen().getNachweisbehinderung().isEmpty()) {
            String now = SPDataUtils.getFormattedDate((Date)new Date());
            for (NachweisBehinderungTyp d2 : m.getNachweisbehinderungen().getNachweisbehinderung()) {
                String giltbis;
                String giltab = d2.getGiltab() != null ? d2.getGiltab() : now;
                String string = giltbis = d2.getGiltbis() != null ? d2.getGiltbis() : now;
                if (giltab.compareTo(now) > 0 || now.compareTo(giltbis) > 0) continue;
                this.disabilities.add(d2.getArt() + "");
            }
            this.disabilities.stream().forEach(d -> this.disabilityWeights.add(100 / this.disabilities.size()));
        }
        this.setBirthdate(SPDataUtils.getFormattedDate((String)m.getGeburtsdatum()));
        this.setPlaceOfBirth(this.trim(m.getGeburtsort()));
        this.setNameAtBirth(this.trim(m.getGeburtsname()));
        this.setSsn(this.trim(m.getSvnummer()));
        this.setPhone(this.trim(m.getTelefonBetrieb()));
        this.setMobile(this.trim(m.getMobilBetrieb()));
        this.setFax(this.trim(m.getTelefaxBetrieb()));
        this.setEmail(this.trim(m.getEmailPrivat()));
        this.setPrivPhone(this.trim(m.getTelefonPrivat()));
        this.setPrivMobile(this.trim(m.getMobilPrivat()));
        this.setPrivFax(this.trim(m.getTelefaxPrivat()));
        this.setPrivEmail(this.trim(m.getEmailPrivat()));
        if (m.getUrlaubskonto() != null && !m.getUrlaubskonto().getBuchung().isEmpty()) {
            this.setVacationDays(Integer.valueOf(((UrlaubskontoBuchungTyp)m.getUrlaubskonto().getBuchung().get(0)).getWert().intValue()));
        }
        if (m.getFelder() != null && !m.getFelder().getFeld().isEmpty()) {
            this.setNationality(this.trim(SPDataUtils.getCurrentFieldValue((String)"Nationalitaet", (String)"name", (Daten.Mitarbeiter)m)));
            this.setTaxNumber(this.trim(SPDataUtils.getCurrentFieldValue((String)"SteuerID", (Daten.Mitarbeiter)m)));
            String taxBrackets = SPDataUtils.getCurrentFieldValue((String)"Steuerklasse", (Daten.Mitarbeiter)m);
            if (taxBrackets != null) {
                this.setTaxBracket(TaxBrackets.fromString((String)taxBrackets));
            }
            this.setDenomination(SPDataUtils.getDenomination((Daten.Mitarbeiter)m));
            this.setMaritalStatus(SPDataUtils.getMaritalStatus((Daten.Mitarbeiter)m));
            String numChildren = SPDataUtils.getCurrentFieldValue((String)"AnzahlKinder", (Daten.Mitarbeiter)m);
            if (numChildren != null) {
                this.setNumberOfChildrens(Integer.valueOf(Integer.parseInt(numChildren)));
            }
            this.setCostCenter(SPDataUtils.getCurrentFieldValue((String)"Stammkostenstelle", (String)"bezeichnung", (Daten.Mitarbeiter)m));
            this.setHierarchyitem(SPDataUtils.getCurrentFieldValue((String)"HROrganisation", (Daten.Mitarbeiter)m));
        }
        this.setEntryAndExitDates(m);
        List mandant = m.getMandanten().getMandant();
        if (mandant != null && !mandant.isEmpty() && (typ = SPDataUtils.getCurrentMandator((Daten.Mitarbeiter)m)) != null && typ.getNummer() != null && typ.getId() != null) {
            this.setMandantennummer(typ.getNummer());
            this.setMandantenId(typ.getId().toString());
        }
    }

    private String trim(String in) {
        if (in == null) {
            return in;
        }
        return in.strip();
    }

    public void update(Daten.Mitarbeiter m) {
        this.copyProperties(m);
    }

    @JsonIgnore
    public String getNameAndIds() {
        return this.firstname + " " + this.lastname + " " + this.valueOr(this.identcode, "-") + "/" + this.valueOr(this.getMandantennummer(), "-") + "/" + this.valueOr(this.getCompany(), "-");
    }

    @JsonIgnore
    private String valueOr(String value, String defaultValue) {
        return value == null ? defaultValue : value;
    }

    @JsonIgnore
    public String getNameAndAllIds() {
        return this.firstname + " " + this.lastname + " [transferId=" + this.id + ", identcode=" + this.identcode + ", mandator=" + this.getMandantennummer() + ", company=" + this.getCompany() + ", syncId=" + this.getSyncId() + "]";
    }

    @JsonIgnore
    private void setEntryAndExitDates(Daten.Mitarbeiter m) {
        List zeitraumList;
        ZeitraumListeTyp lohnbeschaeftigungen = m.getLohnbeschaeftigungen();
        if (lohnbeschaeftigungen != null && !(zeitraumList = lohnbeschaeftigungen.getZeitraum()).isEmpty()) {
            String end;
            int last = zeitraumList.size() - 1;
            ZeitraumTyp zeitraum = (ZeitraumTyp)zeitraumList.get(last);
            String begin = zeitraum.getBeginn();
            if (StringUtils.hasText((String)begin)) {
                this.setEntrydate(this.getFormattedDate(begin));
            }
            if (StringUtils.hasText((String)(end = zeitraum.getEnde()))) {
                this.setExitdate(this.getFormattedDate(end));
            }
        }
    }

    @JsonIgnore
    private Date getFormattedDate(String dateStr) {
        Date date = null;
        try {
            date = sdf.parse(dateStr);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not parse date: " + dateStr, e);
        }
        return date;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public String getLastname() {
        return this.lastname;
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Sex getSex() {
        return this.sex;
    }

    public void setSex(Sex sex) {
        this.sex = sex;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getMobile() {
        return this.mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getPrivMobile() {
        return this.privMobile;
    }

    public void setPrivMobile(String privMobile) {
        this.privMobile = privMobile;
    }

    public String getFax() {
        return this.fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public AddressDto getPrivateAddress() {
        return this.privateAddress;
    }

    public void setPrivateAddress(AddressDto privateAddress) {
        this.privateAddress = privateAddress;
    }

    public Date getBirthdate() {
        return this.birthdate;
    }

    public void setBirthdate(Date birthdate) {
        this.birthdate = birthdate;
    }

    public String getHierarchyitem() {
        return this.hierarchyitem;
    }

    public void setHierarchyitem(String hierarchyitemTransferId) {
        this.hierarchyitem = hierarchyitemTransferId;
    }

    public String getPrivPhone() {
        return this.privPhone;
    }

    public void setPrivPhone(String privPhone) {
        this.privPhone = privPhone;
    }

    public String getPrivFax() {
        return this.privFax;
    }

    public void setPrivFax(String privFax) {
        this.privFax = privFax;
    }

    public String getPrivEmail() {
        return this.privEmail;
    }

    public void setPrivEmail(String privEmail) {
        this.privEmail = privEmail;
    }

    public String getSsn() {
        return this.ssn;
    }

    public void setSsn(String ssn) {
        this.ssn = ssn;
    }

    public String getNameAtBirth() {
        return this.nameAtBirth;
    }

    public void setNameAtBirth(String nameAtBirth) {
        this.nameAtBirth = nameAtBirth;
    }

    public String getPlaceOfBirth() {
        return this.placeOfBirth;
    }

    public void setPlaceOfBirth(String placeOfBirth) {
        this.placeOfBirth = placeOfBirth;
    }

    public String getNationality() {
        return this.nationality;
    }

    public void setNationality(String nationality) {
        this.nationality = nationality;
    }

    public String getTaxNumber() {
        return this.taxNumber;
    }

    public void setTaxNumber(String taxNumber) {
        this.taxNumber = taxNumber;
    }

    public Integer getVacationDays() {
        return this.vacationDays;
    }

    public void setVacationDays(Integer vacationDays) {
        this.vacationDays = vacationDays;
    }

    public Integer getNumberOfChildrens() {
        return this.numberOfChildrens;
    }

    public void setNumberOfChildrens(Integer numberOfChildrens) {
        this.numberOfChildrens = numberOfChildrens;
    }

    public MaritalStatus getMaritalStatus() {
        return this.maritalStatus;
    }

    public void setMaritalStatus(MaritalStatus maritalStatus) {
        this.maritalStatus = maritalStatus;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getIdentcode() {
        return this.identcode;
    }

    public void setIdentcode(String identcode) {
        this.identcode = identcode;
    }

    public String getBankAccountIban() {
        return this.bankAccountIban;
    }

    public void setBankAccountIban(String bankAccountIban) {
        this.bankAccountIban = bankAccountIban;
    }

    public String getBankAccountBic() {
        return this.bankAccountBic;
    }

    public void setBankAccountBic(String bankAccountBic) {
        this.bankAccountBic = bankAccountBic;
    }

    public String getBankAccountBankName() {
        return this.bankAccountBankName;
    }

    public void setBankAccountBankName(String bankAccountBankName) {
        this.bankAccountBankName = bankAccountBankName;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public TaxBrackets getTaxBracket() {
        return this.taxBracket;
    }

    public void setTaxBracket(TaxBrackets taxBracket) {
        this.taxBracket = taxBracket;
    }

    public List<String> getDisabilities() {
        return this.disabilities;
    }

    public void setDisabilities(List<String> disabilities) {
        this.disabilities = disabilities;
    }

    public Denomination getDenomination() {
        return this.denomination;
    }

    public void setDenomination(Denomination denomination) {
        this.denomination = denomination;
    }

    public Date getEntrydate() {
        return this.entrydate;
    }

    public void setEntrydate(Date entrydate) {
        this.entrydate = entrydate;
    }

    public Date getExitdate() {
        return this.exitdate;
    }

    public void setExitdate(Date exitdate) {
        this.exitdate = exitdate;
    }

    public List<String> getCostCenters() {
        return this.costCenters;
    }

    public void setCostCenter(String transferId) {
        if (transferId == null) {
            return;
        }
        this.costCenters.clear();
        this.costCenters.add(transferId);
        this.costCenterWeights.clear();
        this.costCenterWeights.add(100);
    }

    public List<Integer> getCostCenterWeights() {
        return this.costCenterWeights;
    }

    public SortedMap<String, String> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(SortedMap<String, String> customFields) {
        this.customFields = customFields;
    }

    public String toString() {
        return "PersonDto [id=" + this.id + ", syncId=" + this.getSyncId() + ", mandator=" + this.getMandantennummer() + ", lastname=" + this.lastname + ", firstname=" + this.firstname + ", sex=" + this.sex + ", title=" + this.title + ", privateAddress=" + this.privateAddress + ", childAllowance=" + this.childAllowance + ", nameAtBirth=" + this.nameAtBirth + ", placeOfBirth=" + this.placeOfBirth + ", birthdate=" + this.birthdate + ", ssn=" + this.ssn + ", phone=" + this.phone + ", privPhone=" + this.privPhone + ", fax=" + this.fax + ", privFax=" + this.privFax + ", email=" + this.email + ", privEmail=" + this.privEmail + ", mobile=" + this.mobile + ", privMobile=" + this.privMobile + ", location=" + this.location + ", retirementDate=" + this.retirementDate + ", bankAccountIban=" + this.bankAccountIban + ", bankAccountBic=" + this.bankAccountBic + ", bankAccountBankName=" + this.bankAccountBankName + ", wageTypes=" + this.wageTypes + ", hierarchyitem=" + this.hierarchyitem + ", workingHoursPerWeek=" + this.workingHoursPerWeek + ", vacationDays=" + this.vacationDays + ", nationality=" + this.nationality + ", taxNumber=" + this.taxNumber + ", taxBracket=" + this.taxBracket + ", numberOfChildrens=" + this.numberOfChildrens + ", maritalStatus=" + this.maritalStatus + ", disabilities=" + this.disabilities + ", disabilityWeights=" + this.disabilityWeights + ", identcode=" + this.identcode + ", denomination=" + this.denomination + ", entrydate=" + this.entrydate + ", costCenters=" + this.costCenters + ", costCenterWeights=" + this.costCenterWeights + "]";
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getSyncId() {
        if (customFieldKeySyncId == null || customFieldKeySyncId.isEmpty()) {
            throw new RuntimeException("customFieldKeyDatevSyncId is not set!");
        }
        return (String)this.getCustomFields().get(customFieldKeySyncId);
    }

    public void setSyncId(String syncId) {
        if (customFieldKeySyncId == null || customFieldKeySyncId.isEmpty()) {
            throw new RuntimeException("customFieldKeyDatevSyncId is not set!");
        }
        this.getCustomFields().put(customFieldKeySyncId, syncId);
    }

    public String getMandantennummer() {
        if (customFieldKeyMandantennummer == null || customFieldKeyMandantennummer.isEmpty()) {
            throw new RuntimeException("customFieldKeyMandantennummer is not set!");
        }
        return (String)this.getCustomFields().get(customFieldKeyMandantennummer);
    }

    public void setMandantennummer(String mandantennummer) {
        if (customFieldKeyMandantennummer == null || customFieldKeyMandantennummer.isEmpty()) {
            throw new RuntimeException("customFieldKeyMandantennummer is not set!");
        }
        this.getCustomFields().put(customFieldKeyMandantennummer, mandantennummer);
    }

    public String getMandantenId() {
        if (customFieldKeyMandantenId == null || customFieldKeyMandantenId.isEmpty()) {
            return "";
        }
        return (String)this.getCustomFields().get(customFieldKeyMandantenId);
    }

    public void setMandantenId(String mandantenId) {
        if (customFieldKeyMandantenId == null || customFieldKeyMandantenId.isEmpty()) {
            return;
        }
        this.getCustomFields().put(customFieldKeyMandantenId, mandantenId);
    }

    public boolean equals(PersonDto other) {
        if (other == null || other.getId() == null || this.id == null) {
            throw new RuntimeException("ids required for equals");
        }
        return this.id.equals(other.getId());
    }

    @Override
    public int compareTo(PersonDto other) {
        String left = this.lastname + this.firstname;
        return left.compareTo(other.getLastname() + other.getFirstname());
    }
}

