/*
 * Decompiled with CFR 0.152.
 */
package de.perview.sp.mail;

import de.perview.sp.dto.PersonDto;
import de.perview.sp.mail.Report;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ImportToPerviewReport
implements Report {
    private StringBuilder message;
    private StringBuilder error;
    private String previousMessage = "";
    private List<PersonDto> createdPersons = new ArrayList();
    private List<PersonDto> updatedPersons = new ArrayList();
    private int unchangedCount = 0;
    private int failedPersonsCount = 0;
    private int elapsedMinutes = 0;

    public ImportToPerviewReport() {
        this.message = new StringBuilder();
        this.error = new StringBuilder();
    }

    public void addCreatedPerson(PersonDto person) {
        this.createdPersons.add(person);
    }

    public void addUpdatedPerson(PersonDto person) {
        this.updatedPersons.add(person);
    }

    public void incrementUnchangedCount() {
        ++this.unchangedCount;
    }

    public void incrementFailedPersonsCount() {
        ++this.failedPersonsCount;
    }

    public void addMessage(int updatedPerviewPersons) {
        this.message.append(String.format("%n%s Person mandators/identcodes updated in perview.%n", "" + updatedPerviewPersons));
    }

    public void addError(PersonDto p, String errorResponse) {
        String field = "";
        String msg = "";
        if (StringUtils.isNotBlank((CharSequence)errorResponse) && errorResponse.contains(",")) {
            List<String> errors = Arrays.asList(errorResponse.replace("\"", "").split(","));
            for (String e : errors) {
                if (!e.contains("code") && e.contains("field")) {
                    field = e.split(":")[1].trim();
                    continue;
                }
                if (!e.contains("message")) continue;
                msg = e.split(":")[1].trim();
            }
        }
        if (p != null) {
            this.error.append(String.format("%nPerson %s was not imported into Perview: %s - %s%n", p.getNameAndIds(), field, msg));
            ++this.failedPersonsCount;
        }
    }

    public void addError(String m) {
        this.error.append(String.format("%nError during import process: %s%n", m));
    }

    public boolean hasError() {
        return !this.error.toString().isEmpty();
    }

    public boolean hasMessageChanged() {
        String msg = this.buildMessage();
        if (this.message.toString().isEmpty() && this.error.toString().isEmpty() && this.createdPersons.isEmpty() && this.updatedPersons.isEmpty()) {
            return false;
        }
        boolean hasChanged = !this.previousMessage.equals(msg);
        this.previousMessage = msg;
        if (!hasChanged) {
            this.clean();
        }
        return hasChanged;
    }

    public String generateMessage() {
        String msg = this.buildMessage();
        this.clean();
        return msg;
    }

    private void clean() {
        this.error = new StringBuilder();
        this.message = new StringBuilder();
        this.createdPersons.clear();
        this.updatedPersons.clear();
        this.unchangedCount = 0;
        this.failedPersonsCount = 0;
        this.elapsedMinutes = 0;
    }

    private String buildMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("\r\n");
        sb.append("\r\n");
        sb.append("Import Report");
        sb.append("\r\n");
        sb.append(this.message.toString());
        sb.append("\r\n");
        sb.append(" Created Persons        : " + this.createdPersons.size() + "\r\n");
        sb.append(" Updated Persons        : " + this.updatedPersons.size() + "\r\n");
        sb.append(" Unchanged Persons      : " + this.unchangedCount + "\r\n");
        sb.append(" Failed Persons      : " + this.failedPersonsCount + "\r\n");
        if (!this.createdPersons.isEmpty()) {
            sb.append("\r\n");
            sb.append("Created Persons:\r\n");
            Collections.sort(this.createdPersons);
            for (PersonDto p : this.createdPersons) {
                sb.append(p.getNameAndIds() + "\r\n");
            }
        }
        if (!this.updatedPersons.isEmpty()) {
            sb.append("\r\n");
            sb.append("Updated Persons:\r\n");
            Collections.sort(this.updatedPersons);
            for (PersonDto p : this.updatedPersons) {
                sb.append(p.getNameAndIds() + "\r\n");
            }
        }
        sb.append(this.error.toString());
        sb.append(String.format("%nElapsed minutes: %s%n", this.elapsedMinutes));
        return sb.toString();
    }

    public void setElapsedMinutes(int elapsedMinutes) {
        this.elapsedMinutes = elapsedMinutes;
    }
}

