/*
 * Decompiled with CFR 0.152.
 */
package de.perview.sp.schedulers;

import de.perview.sp.CommonUtils;
import de.perview.sp.LastRunHolder;
import de.perview.sp.api.PerviewApi;
import de.perview.sp.api.PerviewApiClient;
import de.perview.sp.api.SPDataReadApi;
import de.perview.sp.dto.PersonDto;
import de.perview.sp.mail.ExportToSPDataReport;
import de.perview.sp.mail.ImportToPerviewReport;
import de.perview.sp.mail.MailReportSender;
import de.perview.sp.mail.Report;
import de.perview.sp.schedulers.SPDataUtils;
import generated.Mitarbeiter.Daten;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class ImportFromSPDataToPerviewScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(ImportFromSPDataToPerviewScheduler.class);
    @Autowired
    private SPDataReadApi spDataReadApi;
    @Autowired
    private PerviewApi perviewApi;
    @Autowired
    private PerviewApiClient perviewApiClient;
    @Autowired
    private CommonUtils commonUtils;
    @Autowired
    private MailReportSender mail;
    @Autowired
    private LastRunHolder lastExportRunHolder;
    @Value(value="${customFieldKeySyncId:syncId}")
    private String customFieldKeySyncId;
    @Value(value="${customFieldKeyMandantennummer:Mandantennummer}")
    private String customFieldMandantennummer;
    @Value(value="${exportPersonsLimit:0}")
    private Integer exportPersonsLimit;
    @Value(value="${spdataImportXmlFileOut:}")
    private String spdataXmlFile;
    @Value(value="${defaultCompany:}")
    private String defaultCompany;
    @Value(value="${import.schedule.cron.enabled:false}")
    private boolean scheduleEnabled;
    @Value(value="${runImportOnStartup:false}")
    private boolean runImportOnStartup;
    @Value(value="${doUpdatePersonsOnImport:true}")
    private boolean doUpdatePersonsOnImport;
    @Value(value="${doCreatePersonsOnImport:true}")
    private boolean doCreatePersonsOnImport;
    @Value(value="${doLogAllPersonsJsonOnImport:false}")
    private boolean doLogAllPersonsJsonOnImport;
    @Value(value="${export.schedule.cron.enabled:false}")
    private boolean exportScheduleCronEnabled;
    ImportToPerviewReport importReport = new ImportToPerviewReport();
    ExportToSPDataReport exportReport = new ExportToSPDataReport();

    @EventListener(value={ApplicationReadyEvent.class})
    public void onApplicationReady() {
        if (this.runImportOnStartup) {
            this.importFromSPDataToPerview();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="${import.schedule.cron}")
    public synchronized void importFromSPDataToPerview() {
        if (!this.scheduleEnabled) {
            return;
        }
        boolean anyPersonPosted = false;
        try {
            LOG.info("Start import of employees from SP-Data to perview");
            LOG.info("scheduleEnabled=" + this.scheduleEnabled);
            LOG.info("runImportOnStartup=" + this.runImportOnStartup);
            LOG.info("doUpdatePersonsOnImport=" + this.doUpdatePersonsOnImport);
            LOG.info("doCreatePersonsOnImport=" + this.doCreatePersonsOnImport);
            PersonDto.customFieldKeySyncId = this.customFieldKeySyncId;
            PersonDto.customFieldKeyMandantennummer = this.customFieldMandantennummer;
            PersonDto.defaultCompany = this.defaultCompany;
            LOG.info("customFieldKeySyncId=" + this.customFieldKeySyncId);
            LOG.info("customFieldKeyDatevMandator=" + this.customFieldMandantennummer);
            LOG.info("defaultCompany=" + this.defaultCompany);
            LOG.info("exportScheduleCronEnabled (will trigger update of export timestamp)=" + this.exportScheduleCronEnabled);
            List existingPerviewPersons = new ArrayList();
            HashMap<String, PersonDto> existingPerviewPersonsBySyncId = new HashMap<String, PersonDto>();
            existingPerviewPersons = this.perviewApiClient.fetchExistingActivePerviewPersons();
            int existingPerviewPersonsWithoutSyncId = 0;
            for (PersonDto p : existingPerviewPersons) {
                String syncId = p.getSyncId();
                if (StringUtils.hasText((String)syncId)) {
                    PersonDto existing = (PersonDto)existingPerviewPersonsBySyncId.get(syncId);
                    if (existing == null) {
                        existingPerviewPersonsBySyncId.put(syncId, p);
                        continue;
                    }
                    LOG.warn("Found more than one person with sysncId: " + syncId);
                    LOG.warn("person: " + existing);
                    LOG.warn("and: " + p);
                    continue;
                }
                ++existingPerviewPersonsWithoutSyncId;
            }
            LOG.info("existingPerviewPersonsBySyncId=" + existingPerviewPersonsBySyncId.size());
            LOG.info("existingPerviewPersonsWithoutSyncId=" + existingPerviewPersonsWithoutSyncId);
            LOG.info("Fetching SP-Data employees: ");
            Daten spdata = this.spDataReadApi.getMitarbeiter();
            LOG.info("Writing received SP-Data xml to file: " + this.spdataXmlFile);
            SPDataUtils.writeSpDataToFile((Daten)spdata, (String)this.spdataXmlFile);
            LOG.info("Fetching mitarbeiter list from xml: ");
            List employees = spdata.getMitarbeiter();
            LOG.info("Retrieved employees from SP-Data {} ", (Object)employees.size());
            for (Daten.Mitarbeiter m : employees) {
                PersonDto p = (PersonDto)existingPerviewPersonsBySyncId.get(m.getSyncid());
                LOG.info("Processing mitarbeiter from SP-Data: {} {} {}", new Object[]{m.getSyncid(), m.getVorname(), m.getNachname()});
                boolean doPost = false;
                boolean isUpdate = false;
                boolean isCreate = false;
                try {
                    if (p != null) {
                        if (this.doUpdatePersonsOnImport) {
                            isUpdate = true;
                            LOG.info("Found matching existing perview person: {}", (Object)p.getNameAndAllIds());
                            String personJsonBeforeUpdate = this.pretty((Object)p);
                            p.update(m);
                            String personJsonAfterUpdate = this.pretty((Object)p);
                            boolean bl = doPost = !personJsonAfterUpdate.equals(personJsonBeforeUpdate);
                            if (doPost || this.doLogAllPersonsJsonOnImport) {
                                LOG.info("personJsonBeforeUpdate=" + personJsonBeforeUpdate);
                                LOG.info("personJsonAfterUpdate=" + personJsonAfterUpdate);
                            }
                        }
                    } else if (this.doCreatePersonsOnImport) {
                        isCreate = true;
                        p = new PersonDto(m);
                        String newPersonJson = this.pretty((Object)p);
                        LOG.info("Creating new perview person from SP-Data mitarbeiter: {}", (Object)p.getNameAndAllIds());
                        LOG.info("newPersonJson=" + newPersonJson);
                        doPost = true;
                    }
                    LOG.info("--> doPost=" + doPost + ", isUpdate=" + isUpdate + ", isCreate=" + isCreate);
                    if (doPost && p != null && (isUpdate && this.doUpdatePersonsOnImport || isCreate && this.doCreatePersonsOnImport)) {
                        ResponseEntity response = this.perviewApi.postPerviewPerson(p);
                        anyPersonPosted = true;
                        if (HttpStatus.CREATED == response.getStatusCode()) {
                            this.importReport.addCreatedPerson(p);
                            LOG.info("Created Person: {}", (Object)p.getNameAndAllIds());
                        }
                        if (HttpStatus.OK != response.getStatusCode()) continue;
                        this.importReport.addUpdatedPerson(p);
                        LOG.info("Updated Person: {}", (Object)p.getNameAndAllIds());
                        continue;
                    }
                    if (p == null) continue;
                    LOG.info("Unchanged Person: {}", (Object)p.getNameAndAllIds());
                    this.importReport.incrementUnchangedCount();
                }
                catch (Exception e) {
                    this.importReport.addError(p, e.getMessage());
                    LOG.error("Import of person failed: ", (Object)p.getNameAndAllIds(), (Object)e);
                }
            }
            this.mail.send((Report)this.importReport);
            LOG.info("Finished import of employees from SP-Data to perview");
        }
        catch (Exception ex) {
            this.importReport.addError(this.commonUtils.getExceptionDetails((Throwable)ex));
            this.mail.send((Report)this.importReport);
            LOG.error("Failed import of employees from SP-Data to perview", (Throwable)ex);
        }
        finally {
            LOG.info("anyPersonPosted=" + anyPersonPosted);
            if (anyPersonPosted) {
                LOG.info("exportScheduleCronEnabled=" + this.exportScheduleCronEnabled);
                if (this.exportScheduleCronEnabled) {
                    try {
                        Date importFinished = new Date();
                        LOG.info("Updating last export timestamp file: " + this.commonUtils.getFormattedDate(importFinished, "yyyy-MM-dd_HH:mm:ss"));
                        this.lastExportRunHolder.updateLastExportTimestamp(importFinished);
                        LOG.info("Successfully updated last export timestamp file as required after importing persons from SPDATA");
                    }
                    catch (ParseException e) {
                        LOG.error("!!! Failed to update the reuqired last export timestamp after person changes !!!");
                        LOG.error("!!! Edit file manually before next export !!!");
                    }
                }
            }
            if (!this.exportScheduleCronEnabled || !anyPersonPosted) {
                LOG.info("Last export timestamp not updated");
            }
        }
    }

    private String pretty(Object object) {
        return this.commonUtils.pretty(object, true);
    }
}

