/*
 * Decompiled with CFR 0.152.
 */
package de.perview.sp.schedulers;

import de.perview.sp.api.MandantenConfig;
import de.perview.sp.api.PerviewElementNSImpl;
import de.perview.sp.dto.AddressDto;
import de.perview.sp.dto.Denomination;
import de.perview.sp.dto.MaritalStatus;
import de.perview.sp.dto.PersonDto;
import de.perview.sp.dto.PersonValidFromDto;
import de.perview.sp.dto.Sex;
import de.perview.sp.schedulers.SPDataUtils;
import generated.Mitarbeiter.AdresseListeTyp;
import generated.Mitarbeiter.AdresseTyp;
import generated.Mitarbeiter.BankverbindungTyp;
import generated.Mitarbeiter.Daten;
import generated.Mitarbeiter.FeldListeTyp;
import generated.Mitarbeiter.FeldTyp;
import generated.Mitarbeiter.FeldWertTyp;
import generated.Mitarbeiter.GeschlechtTyp;
import generated.Mitarbeiter.LandTyp;
import generated.Mitarbeiter.MandantListeTyp;
import generated.Mitarbeiter.MandantTyp;
import generated.Mitarbeiter.NachweisBehinderungListeTyp;
import generated.Mitarbeiter.NachweisBehinderungTyp;
import generated.Mitarbeiter.ZahlungsartTyp;
import generated.Mitarbeiter.ZahlungsartenListeTyp;
import generated.Mitarbeiter.ZeitraumListeTyp;
import generated.Mitarbeiter.ZeitraumTyp;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.w3c.dom.Element;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class SPDataUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SPDataUtils.class);
    @Autowired
    private MandantenConfig mandantenConfig;
    @Value(value="${bank.account.type}")
    private String bankAccountType;
    @Value(value="${address.new.giltbis}")
    private String newAddressGiltBis;

    public static String getCurrentFieldValue(String fieldName, Daten.Mitarbeiter m) {
        return SPDataUtils.getCurrentFieldValue((String)fieldName, null, (Daten.Mitarbeiter)m);
    }

    public static String getCurrentFieldValue(String fieldName, String subFieldName, Daten.Mitarbeiter m) {
        String currentValue = null;
        FeldListeTyp fields = m.getFelder();
        if (fields != null) {
            List fieldTypes = fields.getFeld();
            if ((fieldTypes = fieldTypes.stream().filter(f -> f != null && fieldName.equals(f.getSyncid())).collect(Collectors.toList())).size() > 0) {
                FeldTyp fieldType = (FeldTyp)fieldTypes.get(0);
                String giltabMax = null;
                String now = SPDataUtils.getFormattedDate((Date)new Date());
                List fieldValueTypes = fieldType.getWert();
                for (FeldWertTyp fieldValueType : fieldValueTypes) {
                    String giltab = fieldValueType.getGiltab();
                    if (now.compareTo(giltab) < 0 || giltabMax != null && giltabMax.compareTo(giltab) >= 0) continue;
                    giltabMax = giltab;
                    List contents = fieldValueType.getContent();
                    if (subFieldName != null) {
                        for (Object o : contents) {
                            try {
                                Object e;
                                if (!StringUtils.isNotBlank((CharSequence)o.toString())) continue;
                                if (o instanceof PerviewElementNSImpl) {
                                    e = (PerviewElementNSImpl)o;
                                    if (!e.getLocalName().equalsIgnoreCase(subFieldName)) continue;
                                    currentValue = e.getTextContent();
                                    continue;
                                }
                                if (!(o instanceof Element) || !(e = (Element)o).getLocalName().equalsIgnoreCase(subFieldName)) continue;
                                currentValue = e.getTextContent();
                            }
                            catch (Exception ignore) {
                                LOG.error("Exception ignored: ", (Throwable)ignore);
                            }
                        }
                        continue;
                    }
                    currentValue = contents.stream().map(n -> n.toString()).collect(Collectors.joining(","));
                }
            }
        }
        return currentValue;
    }

    public static MandantTyp getCurrentMandator(Daten.Mitarbeiter m) {
        MandantTyp currentValue = null;
        MandantListeTyp mandators = m.getMandanten();
        if (mandators != null) {
            List mandatorsList = mandators.getMandant();
            String now = SPDataUtils.getFormattedDate((Date)new Date());
            String giltabMax = null;
            for (MandantTyp mandator : mandatorsList) {
                String giltab;
                if (mandator == null || now.compareTo(giltab = mandator.getGiltab()) < 0 || giltabMax != null && giltabMax.compareTo(giltab) >= 0) continue;
                giltabMax = giltab;
                currentValue = mandator;
            }
        }
        return currentValue;
    }

    public static AdresseTyp getCurrentAddress(Daten.Mitarbeiter m) {
        String now = SPDataUtils.getFormattedDate((Date)new Date());
        if (m.getAdressen() == null) {
            return null;
        }
        List addresses = m.getAdressen().getAdresse();
        if (addresses == null) {
            return null;
        }
        if (addresses.size() == 1) {
            return (AdresseTyp)addresses.get(0);
        }
        for (AdresseTyp adresseTyp : addresses) {
            String giltab = adresseTyp.getGiltab();
            String giltbis = adresseTyp.getGiltbis();
            if (StringUtils.isEmpty((CharSequence)giltab) && StringUtils.isEmpty((CharSequence)giltbis)) {
                return adresseTyp;
            }
            if (!(StringUtils.isEmpty((CharSequence)giltab) && StringUtils.isNotEmpty((CharSequence)giltbis) ? giltbis.compareTo(now) >= 0 : (StringUtils.isNotEmpty((CharSequence)giltab) && StringUtils.isNotEmpty((CharSequence)giltbis) ? giltab.compareTo(now) <= 0 && now.compareTo(giltbis) <= 0 : StringUtils.isNotEmpty((CharSequence)giltab) && StringUtils.isEmpty((CharSequence)giltbis) && giltab.compareTo(now) <= 0))) continue;
            return adresseTyp;
        }
        return null;
    }

    public static Date getFormattedDate(String dateStr) {
        if (dateStr == null || dateStr.isEmpty()) {
            return null;
        }
        Date date = null;
        try {
            date = new SimpleDateFormat("yyyyMMdd").parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static String getFormattedDate(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        return format.format(date);
    }

    public static Sex getSexFromGeschlechtTyp(GeschlechtTyp geschlechtTyp) {
        Sex s = Sex.UNKNOWN;
        switch (1.$SwitchMap$generated$Mitarbeiter$GeschlechtTyp[geschlechtTyp.ordinal()]) {
            case 1: {
                s = Sex.MALE;
                break;
            }
            case 2: {
                s = Sex.FEMALE;
                break;
            }
            case 3: {
                s = Sex.DIVERSE;
                break;
            }
        }
        return s;
    }

    public static GeschlechtTyp getGeschlechtTypFromSex(Sex s) {
        GeschlechtTyp g = GeschlechtTyp.U;
        switch (1.$SwitchMap$de$perview$sp$dto$Sex[s.ordinal()]) {
            case 1: {
                g = GeschlechtTyp.M;
                break;
            }
            case 2: {
                g = GeschlechtTyp.W;
                break;
            }
            case 3: {
                g = GeschlechtTyp.D;
                break;
            }
        }
        return g;
    }

    public static FeldTyp getBaseField(String fieldName, String fieldValue) {
        if (fieldName == null || fieldName.isEmpty() || fieldValue == null || fieldValue.isEmpty()) {
            return null;
        }
        FeldTyp field = new FeldTyp();
        field.setSyncid(fieldName);
        FeldWertTyp fType = new FeldWertTyp();
        fType.setGiltab(SPDataUtils.getFormattedDate((Date)new Date()));
        fType.getContent().add(fieldValue);
        field.getWert().add(fType);
        return field;
    }

    public static List<String> getBaseValues(FeldTyp field) {
        if (field == null) {
            return null;
        }
        ArrayList<String> wertList = new ArrayList<String>();
        for (FeldWertTyp wert : field.getWert()) {
            wertList.add(wert.getContent().stream().map(Object::toString).collect(Collectors.joining()));
        }
        return wertList;
    }

    public static MaritalStatus getMaritalStatus(Daten.Mitarbeiter m) {
        String baseValue = SPDataUtils.getCurrentFieldValue((String)"Familienstand", (Daten.Mitarbeiter)m);
        if (baseValue == null) {
            return null;
        }
        MaritalStatus s = null;
        switch (Integer.parseInt(baseValue)) {
            case 0: 
            case 8: {
                s = MaritalStatus.SINGLE;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                s = MaritalStatus.MARRIED;
                break;
            }
            case 3: 
            case 9: {
                s = MaritalStatus.DIVORCED;
                break;
            }
            case 5: {
                s = MaritalStatus.WIDOWER;
                break;
            }
            case 10: {
                s = MaritalStatus.CIVIL_UNION;
                break;
            }
        }
        return s;
    }

    public static String getMaritalStatus(MaritalStatus maritalStatus) {
        if (maritalStatus == null) {
            return null;
        }
        Integer s = null;
        switch (1.$SwitchMap$de$perview$sp$dto$MaritalStatus[maritalStatus.ordinal()]) {
            case 1: {
                s = 0;
                break;
            }
            case 2: {
                s = 1;
                break;
            }
            case 3: {
                s = 3;
                break;
            }
            case 4: {
                s = 5;
                break;
            }
            case 5: {
                s = 10;
                break;
            }
        }
        if (s == null) {
            return null;
        }
        return "" + s;
    }

    public static Denomination getDenomination(Daten.Mitarbeiter m) {
        String baseValue = SPDataUtils.getCurrentFieldValue((String)"KircheMitarbeiter", (String)"kuerzel", (Daten.Mitarbeiter)m);
        if (baseValue == null) {
            return null;
        }
        Denomination s = null;
        switch (baseValue.toLowerCase()) {
            case "ev": {
                s = Denomination.EVANGELICAL;
                break;
            }
            case "rk": {
                s = Denomination.CATHOLIC;
                break;
            }
            case "vd": {
                s = Denomination.UNKNOWN;
                break;
            }
            case "fb": {
                s = Denomination.NONE;
                break;
            }
        }
        return s;
    }

    public Daten.Mitarbeiter buildSpdataEmployee(Daten.Mitarbeiter m, PersonDto p, PersonValidFromDto personValidFromDto, boolean create) {
        LOG.debug("buildSpdataEmployee: create=" + create + ", person=" + p.getNameAndAllIds() + ", in=" + SPDataUtils.getAsString((Daten.Mitarbeiter)m));
        if (m.getFelder() == null) {
            m.setFelder(new FeldListeTyp());
        }
        this.updatePersonDetails(p, m);
        this.updatePrivateAddress(p, m);
        this.updateContactDetailsFelds(p, m);
        this.createOrUpdateBankFeld(p, m);
        this.updateCostCenter(p, m);
        this.createWageTypeFeld(p, m, create);
        this.createOrUpdateMandantFeld(p, m, create);
        if (m.getFelder().getFeld().isEmpty()) {
            m.setFelder(null);
        }
        LOG.debug("buildSpdataEmployee: create=" + create + ", out=" + SPDataUtils.getAsString((Daten.Mitarbeiter)m));
        return m;
    }

    public void updateCostCenter(PersonDto p, Daten.Mitarbeiter m) {
        if (p.getCostCenters() == null || p.getCostCenters().isEmpty()) {
            return;
        }
        this.updateField("Stammkostenstelle", "nummer", (String)p.getCostCenters().get(0), m);
    }

    public void createWageTypeFeld(PersonDto p, Daten.Mitarbeiter m, boolean create) {
        if (create && p.getEntrydate() != null) {
            ZeitraumListeTyp wageOrTempJobList = new ZeitraumListeTyp();
            ZeitraumTyp wageOrTempJob = new ZeitraumTyp();
            wageOrTempJob.setBeginn(SPDataUtils.getFormattedDate((Date)p.getEntrydate()));
            wageOrTempJobList.getZeitraum().add(wageOrTempJob);
            m.setLohnbeschaeftigungen(wageOrTempJobList);
        }
    }

    public void updateContactDetailsFelds(PersonDto p, Daten.Mitarbeiter m) {
        m.setTelefonBetrieb(p.getPhone());
        m.setTelefonPrivat(p.getPrivPhone());
        m.setMobilBetrieb(p.getMobile());
        m.setMobilPrivat(p.getPrivMobile());
        m.setTelefaxBetrieb(p.getFax());
        m.setTelefaxPrivat(p.getPrivFax());
        m.setEmailBetrieb(p.getEmail());
        m.setEmailPrivat(p.getPrivEmail());
    }

    public void updatePersonDetails(PersonDto p, Daten.Mitarbeiter m) {
        m.setPersonalnr(p.getIdentcode());
        m.setNachname(p.getLastname());
        m.setTitel(p.getTitle());
        m.setVorname(p.getFirstname());
        m.setGeburtsname(p.getNameAtBirth());
        m.setGeburtsort(p.getPlaceOfBirth());
        m.setGeburtsdatum(SPDataUtils.getFormattedDate((Date)p.getBirthdate()));
        m.setSvnummer(p.getSsn());
        this.updateField("Diensteintritt", SPDataUtils.getFormattedDate((Date)p.getEntrydate()), m);
        m.setGeschlecht(SPDataUtils.getGeschlechtTypFromSex((Sex)p.getSex()));
        this.updateField("Befristungsdatum", SPDataUtils.getFormattedDate((Date)p.getExitdate()), m);
        this.updateField("SteuerID", p.getTaxNumber(), m);
        String taxBracket = p.getTaxBracket() != null ? "" + p.getTaxBracket().getNumberFiscalCode() : null;
        this.updateField("Steuerklasse", taxBracket, m);
        if (p.getNumberOfChildrens() != null) {
            this.updateField("AnzahlKinder", "" + p.getNumberOfChildrens(), m);
        }
        this.updateMaritalStatus(p, m);
        String vacationDays = p.getVacationDays() != null ? "" + p.getVacationDays() : null;
        this.updateField("Urlaubsanspruch", vacationDays, m);
    }

    protected void updateMaritalStatus(PersonDto p, Daten.Mitarbeiter m) {
        String newValue = null;
        MaritalStatus newMaritalStatus = p.getMaritalStatus();
        if (newMaritalStatus != null) {
            newValue = newMaritalStatus.name();
        }
        if (newValue != null) {
            this.updateField("Familienstand", SPDataUtils.getMaritalStatus((MaritalStatus)newMaritalStatus), m);
        }
    }

    private void updateField(String fieldName, String newValue, Daten.Mitarbeiter m) {
        this.updateField(fieldName, null, newValue, m);
    }

    private void updateField(String fieldName, String subField, String newValue, Daten.Mitarbeiter m) {
        FeldListeTyp fields;
        String oldValue = SPDataUtils.getCurrentFieldValue((String)fieldName, (String)subField, (Daten.Mitarbeiter)m);
        if (this.hasChanged(fieldName, oldValue, newValue) && (fields = m.getFelder()) != null) {
            List fieldTypes = fields.getFeld();
            fieldTypes = fieldTypes.stream().filter(f -> f != null && fieldName.equals(f.getSyncid())).collect(Collectors.toList());
            FeldTyp field = null;
            if (fieldTypes.size() > 0) {
                field = (FeldTyp)fieldTypes.get(0);
            } else {
                field = new FeldTyp();
                field.setSyncid(fieldName);
                fields.getFeld().add(field);
            }
            FeldWertTyp fType = new FeldWertTyp();
            fType.setGiltab(SPDataUtils.getFormattedDate((Date)new Date()));
            if (subField != null) {
                fType.getContent().add(new PerviewElementNSImpl(subField, newValue).getElement());
            } else {
                fType.getContent().add(newValue);
            }
            field.getWert().add(fType);
        }
    }

    public void createOrUpdateBankFeld(PersonDto p, Daten.Mitarbeiter m) {
        if (StringUtils.isNotBlank((CharSequence)p.getBankAccountBankName()) || StringUtils.isNotBlank((CharSequence)p.getBankAccountBic()) || StringUtils.isNotBlank((CharSequence)p.getBankAccountIban())) {
            m.setGehaltskonto(new BankverbindungTyp());
            m.getGehaltskonto().setSyncid(UUID.randomUUID().toString());
            m.getGehaltskonto().setBic(p.getBankAccountBic());
            m.getGehaltskonto().setIban(p.getBankAccountIban());
            m.getGehaltskonto().setBankname(p.getBankAccountBankName());
            m.getGehaltskonto().setKontoart(BigInteger.ONE);
            String syncId = p.getSyncId();
            if (syncId.isEmpty()) {
                syncId = p.getId();
            }
            m.getGehaltskonto().setMitarbeiter(syncId);
            ZahlungsartenListeTyp zahlungsarten = m.getGehaltskonto().getZahlungsarten();
            if (zahlungsarten == null || zahlungsarten.getZahlungsart().isEmpty()) {
                ZahlungsartenListeTyp listeTyp = new ZahlungsartenListeTyp();
                ZahlungsartTyp typ = new ZahlungsartTyp();
                typ.setGiltab(SPDataUtils.getFormattedDate((Date)new Date()));
                typ.setValue(new BigInteger(this.bankAccountType));
                listeTyp.getZahlungsart().add(typ);
                m.getGehaltskonto().setZahlungsarten(listeTyp);
            }
        }
    }

    public void createDisabilitiesFeld(PersonDto p, Daten.Mitarbeiter m) {
        if (!p.getDisabilities().isEmpty()) {
            m.setNachweisbehinderungen(new NachweisBehinderungListeTyp());
            for (String disability : p.getDisabilities()) {
                NachweisBehinderungTyp d = new NachweisBehinderungTyp();
                try {
                    d.setArt(new BigInteger(disability));
                }
                catch (Exception e) {
                    d.setArt(BigInteger.ONE);
                }
                m.getNachweisbehinderungen().getNachweisbehinderung().add(d);
            }
        }
    }

    protected void createOrUpdateMandantFeld(PersonDto p, Daten.Mitarbeiter m, boolean create) {
        if (create) {
            MandantTyp mandantTyp = new MandantTyp();
            mandantTyp.setGiltab(SPDataUtils.getFormattedDate((Date)new Date()));
            String newMandantennummer = p.getMandantennummer();
            String newMandantenId = p.getMandantenId();
            if (StringUtils.isNotBlank((CharSequence)newMandantenId) && StringUtils.isNotBlank((CharSequence)newMandantennummer)) {
                mandantTyp.setId(new BigInteger(p.getMandantenId()));
                mandantTyp.setNummer(p.getMandantennummer());
            } else if (StringUtils.isNotBlank((CharSequence)newMandantennummer)) {
                mandantTyp.setNummer(p.getMandantennummer());
            } else if (this.mandantenConfig.isUseDefaultMandator()) {
                mandantTyp.setId(new BigInteger(this.mandantenConfig.getId()));
                mandantTyp.setNummer(this.mandantenConfig.getNummer());
            }
            MandantListeTyp mandanten = new MandantListeTyp();
            mandanten.getMandant().add(mandantTyp);
            m.setMandanten(mandanten);
        } else {
            this.updateMandantFeld(p, m);
        }
    }

    public void updateMandantFeld(PersonDto p, Daten.Mitarbeiter m) {
        String newMandantennummer = p.getMandantennummer();
        String newMandantenId = p.getMandantenId();
        String oldMandantennummer = "";
        MandantTyp typ = SPDataUtils.getCurrentMandator((Daten.Mitarbeiter)m);
        if (typ != null) {
            oldMandantennummer = typ.getNummer();
        }
        if (StringUtils.isNotBlank((CharSequence)newMandantennummer) && !newMandantennummer.equals(oldMandantennummer)) {
            MandantTyp mandantTyp = new MandantTyp();
            mandantTyp.setSyncid(UUID.randomUUID().toString());
            mandantTyp.setGiltab(SPDataUtils.getFormattedDate((Date)new Date()));
            if (!StringUtils.isNotBlank((CharSequence)newMandantenId)) {
                mandantTyp.setId(new BigInteger(newMandantenId));
            }
            mandantTyp.setNummer(newMandantennummer);
            MandantListeTyp mandanten = m.getMandanten();
            if (mandanten == null) {
                m.setMandanten(new MandantListeTyp());
            } else if (!mandanten.getMandant().isEmpty()) {
                mandanten.getMandant().clear();
            }
            mandanten.getMandant().add(mandantTyp);
        }
    }

    public void updatePrivateAddress(PersonDto p, Daten.Mitarbeiter m) {
        AddressDto addressNew;
        String oldValue = null;
        String newValue = null;
        AdresseTyp addresseTyp = SPDataUtils.getCurrentAddress((Daten.Mitarbeiter)m);
        if (addresseTyp != null) {
            AddressDto addressOld = new AddressDto(addresseTyp);
            oldValue = addressOld.toString();
        }
        if ((addressNew = p.getPrivateAddress()) != null) {
            newValue = addressNew.toString();
        }
        if (this.hasChanged("adresse", oldValue, newValue) && p.getPrivateAddress() != null && p.getPrivateAddress().isNotEmpty()) {
            AdresseTyp address = new AdresseTyp();
            address.setSyncid(UUID.randomUUID().toString());
            address.setGiltab(SPDataUtils.getFormattedDate((Date)new Date()));
            address.setGiltbis(this.newAddressGiltBis);
            address.setAnschriftenzusatz(p.getPrivateAddress().getAddon());
            address.setStrasse(p.getPrivateAddress().getStreet());
            address.setPlz(p.getPrivateAddress().getZip());
            address.setOrt(p.getPrivateAddress().getTown());
            address.setLand(new LandTyp());
            address.getLand().setName(p.getPrivateAddress().getCountry());
            address.setMitarbeiter(m.getSyncid());
            if (m.getAdressen() == null) {
                m.setAdressen(new AdresseListeTyp());
            }
            if (m.getAdressen().getAdresse().size() >= 1 && addresseTyp != null) {
                Date today = DateUtils.truncate((Date)new Date(), (int)5);
                Date yesterdayDate = DateUtils.addDays((Date)today, (int)-1);
                String yesterday = SPDataUtils.getFormattedDate((Date)yesterdayDate);
                m.getAdressen().getAdresse().remove(addresseTyp);
                addresseTyp.setGiltbis(yesterday);
                m.getAdressen().getAdresse().add(addresseTyp);
            }
            m.getAdressen().getAdresse().add(address);
        }
    }

    private boolean hasChanged(String name, String oldValue, String newValue) {
        boolean result = false;
        if (StringUtils.isEmpty((CharSequence)oldValue) && StringUtils.isEmpty((CharSequence)newValue)) {
            result = false;
        } else if (StringUtils.isEmpty((CharSequence)oldValue) && StringUtils.isNotEmpty((CharSequence)newValue)) {
            result = true;
        } else if (StringUtils.isNotEmpty((CharSequence)oldValue) && StringUtils.isEmpty((CharSequence)newValue)) {
            result = true;
        } else if (StringUtils.isNotEmpty((CharSequence)oldValue) && StringUtils.isNotEmpty((CharSequence)newValue)) {
            result = oldValue.compareTo(newValue) != 0;
        }
        LOG.debug("hasChanged: " + name + " --> " + result + ", oldValue=" + oldValue + ", newValue=" + newValue);
        return result;
    }

    public static String getAsString(Daten spData) {
        String result = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Daten.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            marshaller.marshal((Object)spData, (OutputStream)stream);
            result = new String(stream.toByteArray());
        }
        catch (JAXBException e) {
            LOG.error("Cannot serialize spData", (Throwable)e);
        }
        return result;
    }

    public static String getAsString(Daten.Mitarbeiter m) {
        String result = null;
        if (m != null) {
            Daten spData = new Daten();
            spData.setVersion(BigInteger.ONE);
            spData.getMitarbeiter().add(m);
            result = SPDataUtils.getAsString((Daten)spData);
        }
        return result;
    }

    public static void writeMitarbeiterToFile(Map<String, Daten.Mitarbeiter> mitarbeiter, List<String> sortedMitarbeiterSyncIds, String spdataXmlFile) {
        Daten spData = new Daten();
        spData.setVersion(BigInteger.ONE);
        for (String syncid : sortedMitarbeiterSyncIds) {
            spData.getMitarbeiter().add(mitarbeiter.get(syncid));
        }
        SPDataUtils.writeSpDataToFile((Daten)spData, (String)spdataXmlFile);
    }

    public static void writeSpDataToFile(Daten daten, String spdataXmlFile) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Daten.class});
            Marshaller mar = context.createMarshaller();
            mar.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            mar.marshal((Object)daten, new File(spdataXmlFile));
        }
        catch (Exception e) {
            LOG.error("Cannot write xml to file (ignored): " + e.getMessage(), (Throwable)e);
        }
    }

    public static Daten readSpDataFromFile(String spdataXmlFile) {
        Object data = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Daten.class});
            data = context.createUnmarshaller().unmarshal((Reader)new FileReader(spdataXmlFile));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot read xml from file: " + e.getMessage(), e);
        }
        return (Daten)data;
    }
}

