/*
 * Decompiled with CFR 0.152.
 */
package de.perview.sp.schedulers;

import de.perview.sp.CommonUtils;
import de.perview.sp.api.PerviewApiClient;
import de.perview.sp.api.SPDataApiClient;
import de.perview.sp.dto.PersonDto;
import de.perview.sp.mail.ImportToPerviewReport;
import de.perview.sp.mail.MailReportSender;
import de.perview.sp.mail.Report;
import de.perview.sp.schedulers.SPDataUtils;
import generated.Mitarbeiter.Daten;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class SyncMandatorNrFromSPDataToPerviewScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(SyncMandatorNrFromSPDataToPerviewScheduler.class);
    @Autowired
    private PerviewApiClient perviewApiClient;
    @Autowired
    private MailReportSender mail;
    @Autowired
    private SPDataApiClient sPDataApiClient;
    @Autowired
    private CommonUtils commonUtils;
    @Value(value="${customFieldKeySyncId:syncId}")
    private String customFieldKeySyncId;
    @Value(value="${customFieldKeyMandantennummer:Mandantennummer}")
    private String customFieldMandantennummer;
    @Value(value="${customFieldKeyMandantenId:MandantenId}")
    private String customFieldMandantenId;
    @Value(value="${sync.mandanten.all:false}")
    private boolean syncMandantenAll;
    @Value(value="${sync.mandanten.list:}")
    private List<String> syncPersonsList;
    @Value(value="${sync.mandatornr.schedule.enabled:false}")
    private boolean scheduleEnabled;
    @Value(value="${runSynchronizeMandatorNrSchedulerOnStartup:false}")
    private boolean runSynchronizeMandatorNrSchedulerOnStartup;
    private final ImportToPerviewReport importReport = new ImportToPerviewReport();

    @EventListener(value={ApplicationReadyEvent.class})
    public void onApplicationReady() {
        if (this.runSynchronizeMandatorNrSchedulerOnStartup) {
            this.syncMandatorNr();
        }
    }

    @Scheduled(cron="${sync.mandatornr.schedule.cron:-}")
    public synchronized void syncMandatorNr() {
        if (!this.scheduleEnabled) {
            return;
        }
        LOG.info("Start synchronizing mandators and identcodes of persons");
        long start = System.currentTimeMillis();
        TreeMap perviewPersonsBySyncId = new TreeMap();
        ArrayList updatedPerviewPersons = new ArrayList();
        PersonDto.customFieldKeySyncId = this.customFieldKeySyncId;
        PersonDto.customFieldKeyMandantennummer = this.customFieldMandantennummer;
        PersonDto.customFieldKeyMandantenId = this.customFieldMandantenId;
        try {
            List existingPerviewPersons = this.perviewApiClient.fetchExistingActivePerviewPersons();
            existingPerviewPersons.forEach(person -> {
                if (person.getSyncId() != null) {
                    perviewPersonsBySyncId.put(person.getSyncId(), person);
                }
            });
            this.updateMandatorsAndIdentcodes(existingPerviewPersons, updatedPerviewPersons);
            long end = System.currentTimeMillis();
            this.importReport.setElapsedMinutes(this.getElapsedMinutes(start, end));
            this.mail.send((Report)this.importReport);
            LOG.info("Finished synchronizing mandators and identcodes of persons");
        }
        catch (Exception ex) {
            LOG.error("Failed synchronizing mandators and identcodes of persons: ", (Throwable)ex);
            long end = System.currentTimeMillis();
            this.importReport.setElapsedMinutes(this.getElapsedMinutes(start, end));
            this.importReport.addError("Failed synchronizing mandators and identcodes of persons: " + this.commonUtils.getExceptionDetails((Throwable)ex));
            this.mail.send((Report)this.importReport);
        }
    }

    private void updateMandatorsAndIdentcodes(List<PersonDto> perviewPersons, List<PersonDto> updatedPerviewPersons) {
        LOG.info("updateMandatorsAndIdentcodes: ...");
        try {
            for (PersonDto perviewPerson : perviewPersons) {
                Daten.Mitarbeiter mitarbeiter;
                if (this.shouldSkipPerson(perviewPerson)) continue;
                String syncid = perviewPerson.getSyncId();
                if (!StringUtils.hasText((String)syncid)) {
                    LOG.warn("Person has no syncid (Sync skipped): " + perviewPerson.getNameAndAllIds());
                    continue;
                }
                try {
                    mitarbeiter = this.sPDataApiClient.fetchSpDataMitarbeiterBySyncid(perviewPerson);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to fetch person by syncId from spdata: person=" + perviewPerson.getNameAndAllIds(), e);
                }
                if (mitarbeiter != null) {
                    this.syncMandatorAndIdentcode(perviewPerson, mitarbeiter, updatedPerviewPersons);
                    continue;
                }
                LOG.warn("Person not found in Spdata: " + perviewPerson.getNameAndAllIds());
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("updateMandatorsAndIdentcodes failed: ", ex);
        }
        LOG.info("updateMandatorsAndIdentcodes: done");
    }

    private boolean shouldSkipPerson(PersonDto person) {
        return !this.syncMandantenAll && !this.syncPersonsList.isEmpty() && this.syncPersonsList.stream().noneMatch(pid -> pid.equals(person.getId()));
    }

    private void syncMandatorAndIdentcode(PersonDto perviewPerson, Daten.Mitarbeiter mitarbeiter, List<PersonDto> updatedPerviewPersons) {
        PersonDto spDataPerson = new PersonDto(mitarbeiter);
        String perviewMandator = Optional.ofNullable(perviewPerson.getMandantennummer()).orElse("");
        String spDataMandator = Optional.ofNullable(spDataPerson.getMandantennummer()).orElse("");
        String perviewMandatorId = Optional.ofNullable(perviewPerson.getMandantenId()).orElse("");
        String spDataMandatorId = Optional.ofNullable(spDataPerson.getMandantenId()).orElse("");
        String perviewIdentcode = Optional.ofNullable(perviewPerson.getIdentcode()).orElse("");
        String spDataIdentcode = Optional.ofNullable(spDataPerson.getIdentcode()).orElse("");
        if (!(perviewMandator.equals(spDataMandator) && perviewIdentcode.equals(spDataIdentcode) && perviewMandatorId.equals(spDataMandatorId))) {
            try {
                this.perviewApiClient.updateMandatorAndIdentcodeInPerview(perviewPerson, spDataMandator, spDataIdentcode, spDataMandatorId);
                updatedPerviewPersons.add(perviewPerson);
                this.importReport.addUpdatedPerson(perviewPerson);
                LOG.info("Updated (synched) perview person: " + perviewPerson.getNameAndAllIds());
                LOG.info("mandator: " + perviewMandator + " -> " + spDataMandator);
                LOG.info("identcode: " + perviewIdentcode + " -> " + spDataIdentcode);
            }
            catch (Exception ex) {
                String mitarbeiterAsString = SPDataUtils.getAsString((Daten.Mitarbeiter)mitarbeiter);
                LOG.error("Failed to sync person: " + perviewPerson.getNameAndAllIds() + ", mitarbeiter=" + mitarbeiterAsString, (Throwable)ex);
                this.importReport.addError("Failed to sync person: " + perviewPerson.getNameAndAllIds() + ", mitarbeiter=" + mitarbeiterAsString + ", reason: " + ex.getMessage());
                this.importReport.incrementFailedPersonsCount();
            }
        }
    }

    private int getElapsedMinutes(long startMillis, long endMillis) {
        long difference = endMillis - startMillis;
        return (int)(difference / 60000L % 60L);
    }
}

