/*
 * Decompiled with CFR 0.152.
 */
package de.perview.sp.api;

import de.perview.sp.api.PerviewApi;
import de.perview.sp.dto.PersonDto;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class PerviewApiClient {
    private static final Logger LOG = LoggerFactory.getLogger(PerviewApiClient.class);
    @Autowired
    private PerviewApi perviewApi;

    public void updatePerviewPerson(PersonDto perviewPerson) {
        LOG.info("updatePerviewPerson: person: " + perviewPerson.getNameAndAllIds());
        this.removeCustomFieldsHavingNullValue(perviewPerson);
        ResponseEntity response = this.perviewApi.postPerviewPerson(perviewPerson);
        if (HttpStatus.OK != response.getStatusCode()) {
            throw new RuntimeException("Update perview person failed: Wrong status code for person: " + perviewPerson.getNameAndAllIds() + ", statusCode=" + response.getStatusCodeValue());
        }
    }

    public List<PersonDto> fetchExistingActivePerviewPersons() {
        try {
            List pageOfPersons;
            LOG.info("Fetching existing active perview persons...");
            ArrayList<PersonDto> persons = new ArrayList<PersonDto>();
            int pageSize = 100;
            int page = 0;
            do {
                LOG.info("Fetching page " + (page + 1) + " ...");
                pageOfPersons = this.perviewApi.getPerviewPersonsPaged("systemuser,EQ,false;status,IN,ACTIVE", Integer.valueOf(page++), Integer.valueOf(pageSize), "lastname");
                persons.addAll(pageOfPersons);
                LOG.info("Fetched page " + page + ", persons: " + pageOfPersons.size());
            } while (!pageOfPersons.isEmpty());
            LOG.info("Fetched existing active perview persons: " + persons.size());
            return persons;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching existing perview persons failed: " + e.getLocalizedMessage(), e);
        }
    }

    public void updateMandatorAndIdentcodeInPerview(PersonDto perviewPerson, String spDataMandator, String spDataIdentcode, String spDataMandatorId) {
        LOG.info("updateMandatorAndIdentcodeInPerview: person: " + perviewPerson.getNameAndAllIds());
        LOG.info("updateMandatorAndIdentcodeInPerview: mandantennummer: " + perviewPerson.getMandantennummer() + " --> " + spDataMandator);
        LOG.info("updateMandatorAndIdentcodeInPerview: identcode: " + perviewPerson.getIdentcode() + " --> " + spDataIdentcode);
        perviewPerson.setMandantennummer(spDataMandator);
        perviewPerson.setMandantenId(spDataMandatorId);
        perviewPerson.setIdentcode(spDataIdentcode);
        this.removeCustomFieldsHavingNullValue(perviewPerson);
        ResponseEntity response = this.perviewApi.postPerviewPerson(perviewPerson);
        if (HttpStatus.OK != response.getStatusCode()) {
            throw new RuntimeException("Update failed: Wrong status code for person: " + perviewPerson.getNameAndAllIds() + ", statusCode=" + response.getStatusCodeValue());
        }
    }

    private void removeCustomFieldsHavingNullValue(PersonDto perviewPerson) {
        TreeMap<String, String> customFields = new TreeMap<String, String>();
        SortedMap fields = perviewPerson.getCustomFields();
        for (String key : fields.keySet()) {
            if (fields.get(key) == null) continue;
            customFields.put(key, (String)fields.get(key));
        }
        perviewPerson.setCustomFields(customFields);
    }
}

