/*
 * Decompiled with CFR 0.152.
 */
package de.perview.sp.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import generated.Mitarbeiter.AdresseTyp;
import org.apache.commons.lang3.StringUtils;

public class AddressDto {
    private String street;
    private String addon;
    private String zip;
    private String town;
    private String country;

    public AddressDto() {
    }

    public AddressDto(AdresseTyp address) {
        this.setAddon(address.getAnschriftenzusatz());
        this.setStreet(address.getStrasse());
        this.setZip(address.getPlz());
        this.setTown(address.getOrt());
        this.setCountry(address.getLand() != null ? (address.getLand().getName().equals("Deutschland") ? "Germany" : address.getLand().getName()) : null);
    }

    @JsonIgnore
    public boolean isNotEmpty() {
        return StringUtils.isNotBlank((CharSequence)this.addon) || StringUtils.isNotBlank((CharSequence)this.street) || StringUtils.isNotBlank((CharSequence)this.zip) || StringUtils.isNotBlank((CharSequence)this.town) || StringUtils.isNotBlank((CharSequence)this.country);
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getAddon() {
        return this.addon;
    }

    public void setAddon(String addon) {
        this.addon = addon;
    }

    public String getZip() {
        return this.zip;
    }

    public void setZip(String zip) {
        this.zip = zip;
    }

    public String getTown() {
        return this.town;
    }

    public void setTown(String town) {
        this.town = town;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String toString() {
        return "AddressDto [street=" + this.street + ", addon=" + this.addon + ", zip=" + this.zip + ", town=" + this.town + ", country=" + this.country + "]";
    }
}

