/*
 * Decompiled with CFR 0.152.
 */
package de.perview.sp;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class LastRunHolder {
    @Value(value="${last.export.date.file.path:}")
    private String lastExportDateFileUrl;
    private String initialDate = "2025-01-01_00:00:01";
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss");

    public String getLastRunTimestampString(String url) {
        try {
            List<String> lines;
            Path path = this.getLastRunFilePath(url);
            if (Files.notExists(path, new LinkOption[0])) {
                Files.write(path, Arrays.asList(this.initialDate), new OpenOption[0]);
            }
            if ((lines = Files.readAllLines(path)).isEmpty()) {
                return this.initialDate;
            }
            return lines.get(0);
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public String updateLastRunTimestamp(String url, Date date) {
        try {
            String timestamp = this.sdf.format(date);
            Files.write(this.getLastRunFilePath(url), Arrays.asList(timestamp), new OpenOption[0]);
            return timestamp;
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private Path getLastRunFilePath(String url) throws URISyntaxException {
        return Paths.get(url, new String[0]);
    }

    public void updateLastExportTimestamp(Date date) throws ParseException {
        this.updateLastRunTimestamp(this.lastExportDateFileUrl, date);
    }

    public Date getLastExportTimestamp() throws ParseException {
        return this.sdf.parse(this.getLastRunTimestampString(this.lastExportDateFileUrl));
    }
}

