/*
 * Decompiled with CFR 0.152.
 */
package de.perview.sp;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.SequenceWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvParser;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SimpleCsvMapper {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleCsvMapper.class);
    private CsvMapper mapper = new CsvMapper();

    public SimpleCsvMapper() {
        this.mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        this.mapper.enable(CsvParser.Feature.IGNORE_TRAILING_UNMAPPABLE);
        this.mapper.enable(CsvParser.Feature.TRIM_SPACES);
        this.mapper.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        this.mapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyyMMdd"));
        this.mapper.setTimeZone(TimeZone.getDefault());
        this.mapper.disable(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE);
        this.mapper.configure(CsvParser.Feature.FAIL_ON_MISSING_COLUMNS, false);
        this.mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public <T> List<T> readFromCsv(String filePath, Class<T> cls) {
        LOG.info("Reading csv for class=" + cls.getSimpleName() + ", filePath=" + filePath);
        try {
            File file = new File(filePath);
            CsvSchema cvsSchema = this.mapper.schemaFor(cls).withHeader().withColumnSeparator(';');
            MappingIterator values = this.mapper.readerFor(cls).with((FormatSchema)cvsSchema).readValues(file);
            List result = values.readAll();
            LOG.info("dtos=" + result.size());
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException("Reading csv failed for class=" + cls.getSimpleName() + ", filePath=" + filePath, e);
        }
    }

    public <T> void writeToCsv(String filePath, Class<T> cls, List<T> values) {
        LOG.info("Writing csv for class=" + cls.getSimpleName() + ", filePath=" + filePath + ", entries=" + values.size());
        File file = new File(filePath);
        try (SequenceWriter writer = this.mapper.writerWithSchemaFor(cls).with((FormatSchema)this.mapper.schemaFor(cls).withColumnSeparator(';').withoutQuoteChar().withHeader()).writeValues(file);){
            writer.writeAll(values);
        }
        catch (IOException e) {
            throw new RuntimeException("Writing csv failed for class=" + cls.getSimpleName() + ", filePath=" + filePath, e);
        }
    }
}

