/*
 * Decompiled with CFR 0.152.
 */
package de.perview.sp.api;

import de.perview.sp.api.PerviewApi;
import de.perview.sp.dto.PersonDto;
import de.perview.sp.dto.PersonValidFromDto;
import de.perview.sp.mail.ExportToSPDataReport;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PersonValidator {
    private static final Logger LOG = LoggerFactory.getLogger(PersonValidator.class);
    @Autowired
    private PerviewApi perviewApi;
    @Value(value="#{'${validfrom.fields}'.split(',')}")
    private List<String> validFromFields;
    private PersonValidFromDto validDto;

    public boolean isMandatoryFieldsFilledUp(PersonDto p, ExportToSPDataReport exportReport) {
        HashMap validatedFields = new HashMap();
        this.validFromFields.forEach(f -> validatedFields.put(f, null));
        this.validDto = this.perviewApi.getPersonValidFrom(new PersonValidFromDto(p.getId(), validatedFields));
        StringBuilder invalidMessage = new StringBuilder();
        for (String field : this.validFromFields) {
            try {
                Object f2 = this.getFieldValue(p, field);
                if (f2 != null && !StringUtils.isBlank((CharSequence)f2.toString())) continue;
                invalidMessage.append(String.format("%s is empty, ", field));
            }
            catch (Exception e) {
                LOG.error("Field {} is not in PersonDto. Check application.properties 'validfrom.fields' value.", (Object)field);
            }
        }
        String message = invalidMessage.toString();
        if (message.isEmpty()) {
            return true;
        }
        message = message.substring(0, message.length() - 2);
        LOG.debug("Person {} - Invalid data for fields: {}. Check it on Perview.", (Object)p.getId(), (Object)message);
        exportReport.addErrorInvalidPerson(p, message);
        return false;
    }

    private Object getFieldValue(PersonDto p, String field) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        if (field.contains(".")) {
            String dad = field.split("\\.")[0];
            String child = field.split("\\.")[1];
            PropertyDescriptor pdDad = new PropertyDescriptor(dad, p.getClass());
            Object dadObj = pdDad.getReadMethod().invoke((Object)p, null);
            if (dadObj == null) {
                return null;
            }
            PropertyDescriptor pdChild = new PropertyDescriptor(child, dadObj.getClass());
            return pdChild.getReadMethod().invoke(dadObj, null);
        }
        PropertyDescriptor pd = new PropertyDescriptor(field, p.getClass());
        return pd.getReadMethod().invoke((Object)p, null);
    }

    public PersonValidFromDto getValidDto() {
        return this.validDto;
    }
}

