/*
 * Decompiled with CFR 0.152.
 */
package de.perview.sp.mail;

import de.perview.sp.dto.PersonDto;
import de.perview.sp.mail.Report;
import generated.Mitarbeiter.Daten;
import generated.Mitarbeiter.StatusListeTyp;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class ExportToSPDataReport
implements Report {
    private StringBuilder errors;
    private StringBuilder warnings;
    private StringBuilder infos;
    private List<PersonDto> createdPersons = new ArrayList();
    private List<PersonDto> updatedPersons = new ArrayList();
    private int unchangedCount = 0;
    private int failedPersonsCount = 0;
    private int elapsedMinutes = 0;
    private Date since;
    private Date until;

    public ExportToSPDataReport() {
        this.errors = new StringBuilder();
        this.warnings = new StringBuilder();
        this.infos = new StringBuilder();
    }

    public void addCreatedPerson(PersonDto person) {
        this.createdPersons.add(person);
    }

    public void addUpdatedPerson(PersonDto person) {
        this.updatedPersons.add(person);
    }

    public void setUnchangedCount(int unchangedCount) {
        this.unchangedCount = unchangedCount;
    }

    public void incrementFailedPersonsCount() {
        ++this.failedPersonsCount;
    }

    public void addErrorInvalidPerson(PersonDto p, String m) {
        this.errors.append(String.format("%nPerson %s - Invalid data for fields: %s. Check it on Perview.%n", p.getId(), m));
    }

    public void buildErrorResponse(boolean create, StringBuilder result, String category, PersonDto person, Daten.Mitarbeiter m, StatusListeTyp.Status s, BigInteger bigInteger) {
        result.append(String.format("%n%s %s:%n", this.getOperation(create), person.getNameAndAllIds()));
        result.append(String.format("SP-Data operation reference Id: %s%n", bigInteger.toString()));
        result.append(String.format("SyncId: %s%n", m.getSyncid()));
        result.append(String.format("Feld: %s%n%s: %s%n", s.getFeld(), category, s.getMeldung()));
    }

    public void addErrorResponse(boolean create, String category, PersonDto person, Daten.Mitarbeiter m, StatusListeTyp.Status s, BigInteger bigInteger) {
        this.buildErrorResponse(create, this.errors, category, person, m, s, bigInteger);
    }

    public void addWarningResponse(boolean create, String category, PersonDto person, Daten.Mitarbeiter m, StatusListeTyp.Status s, BigInteger bigInteger) {
        this.buildErrorResponse(create, this.warnings, category, person, m, s, bigInteger);
    }

    public void addInfoResponse(boolean create, String category, PersonDto person, Daten.Mitarbeiter m, StatusListeTyp.Status s, BigInteger bigInteger) {
        this.buildErrorResponse(create, this.infos, category, person, m, s, bigInteger);
    }

    public void addError(boolean create, String m) {
        this.errors.append(String.format("%n%s error during export: %s%n", this.getOperation(create), m));
    }

    public void addError(String m) {
        this.errors.append(String.format("%nError during export process: %s%n", m));
    }

    private String getOperation(boolean create) {
        return create ? "Create" : "Update";
    }

    public boolean hasError() {
        return !this.errors.toString().isEmpty();
    }

    public boolean hasMessageChanged() {
        throw new RuntimeException("Not supported method");
    }

    public String generateMessage() {
        String msg = this.buildMessage();
        this.clean();
        return msg;
    }

    private void clean() {
        this.errors = new StringBuilder();
        this.warnings = new StringBuilder();
        this.infos = new StringBuilder();
        this.createdPersons.clear();
        this.updatedPersons.clear();
        this.unchangedCount = 0;
        this.failedPersonsCount = 0;
        this.elapsedMinutes = 0;
    }

    private String buildMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("\r\n");
        sb.append("\r\n");
        sb.append("Export Report");
        sb.append("\r\n");
        sb.append("\r\n");
        sb.append("Zeitraum: " + this.getFormattedDate(this.since, "dd.MM.yyyy HH:mm") + " - " + this.getFormattedDate(this.until, "dd.MM.yyyy HH:mm"));
        sb.append("\r\n");
        sb.append("\r\n");
        sb.append(" Created persons        : " + this.createdPersons.size() + "\r\n");
        sb.append(" Updated persons        : " + this.updatedPersons.size() + "\r\n");
        sb.append(" Failed persons         : " + this.failedPersonsCount + "\r\n");
        sb.append(" Unchanged persons      : " + this.unchangedCount + "\r\n");
        if (!this.createdPersons.isEmpty()) {
            sb.append("\r\n");
            sb.append("Created persons:\r\n");
            Collections.sort(this.createdPersons);
            for (PersonDto p : this.createdPersons) {
                sb.append(p.getNameAndIds() + "\r\n");
            }
        }
        if (!this.updatedPersons.isEmpty()) {
            sb.append("\r\n");
            sb.append("Updated persons:\r\n");
            Collections.sort(this.updatedPersons);
            for (PersonDto p : this.updatedPersons) {
                sb.append(p.getNameAndIds() + "\r\n");
            }
        }
        if (!this.errors.isEmpty()) {
            sb.append("\r\nFailed persons:");
            sb.append(this.errors.toString());
        }
        if (!this.warnings.isEmpty()) {
            sb.append("\r\nWarnings:");
            sb.append(this.warnings.toString());
        }
        if (!this.infos.isEmpty()) {
            sb.append("\r\nInfos:");
            sb.append(this.infos.toString());
        }
        sb.append(String.format("%nElapsed minutes: %s%n", this.elapsedMinutes));
        return sb.toString();
    }

    public int getFailedPersonsCount() {
        return this.failedPersonsCount;
    }

    public void setFailedPersonsCount(int failedPersonsCount) {
        this.failedPersonsCount = failedPersonsCount;
    }

    public void setElapsedMinutes(int elapsedMinutes) {
        this.elapsedMinutes = elapsedMinutes;
    }

    private String getFormattedDate(Date date, String format) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(date);
    }

    public void setSince(Date since) {
        this.since = since;
    }

    public void setUntil(Date until) {
        this.until = until;
    }
}

