/*
 * Decompiled with CFR 0.152.
 */
package de.perview.sp.mail;

import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.PublicClientApplication;
import com.microsoft.aad.msal4j.UserNamePasswordParameters;
import com.sun.mail.smtp.SMTPTransport;
import de.perview.sp.mail.MailSettings;
import de.perview.sp.mail.Report;
import java.net.MalformedURLException;
import java.util.Base64;
import java.util.Properties;
import java.util.Set;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;

@Component
public class MailReportSender {
    private static final Log LOG = LogFactory.getLog(MailReportSender.class);
    @Autowired
    private MailSettings mailSettings;
    @Autowired
    private JavaMailSender mailSender;
    @Value(value="${mail.office365:false}")
    private boolean mailOffice365;

    public void send(Report report) {
        if (this.mailOffice365) {
            this.sendOffice365(report);
        } else {
            this.sendOther(report);
        }
    }

    public void sendOffice365(Report report) {
        LOG.info((Object)"Preparing mail to be sent via smtp.office365.com");
        try {
            MimeMessage message = this.buildMimeMessage(report);
            SMTPTransport transport = (SMTPTransport)this.mailSession().getTransport("smtp");
            UserNamePasswordParameters parameters = UserNamePasswordParameters.builder((Set)this.mailSettings.getScopes(), (String)this.mailSettings.getUsername(), (char[])this.mailSettings.getPassword().toCharArray()).build();
            IAuthenticationResult authenticationResult = (IAuthenticationResult)this.publicClientApplication().acquireToken(parameters).join();
            LOG.info((Object)"Auth authentication");
            transport.connect("smtp.office365.com", this.mailSettings.getUsername(), null);
            transport.issueCommand("AUTH XOAUTH2 " + this.tokenForSMTP(this.mailSettings.getUsername(), authenticationResult.accessToken()), 235);
            LOG.info((Object)"Sending");
            transport.sendMessage((Message)message, message.getAllRecipients());
            LOG.info((Object)"Mail successfully sent!");
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to send mail", (Throwable)e);
        }
    }

    public void sendOther(Report report) {
        LOG.info((Object)"Preparing mail to be sent");
        try {
            SimpleMailMessage msg = new SimpleMailMessage();
            msg.setFrom(this.mailSettings.getFrom());
            msg.setTo(this.mailSettings.getTo());
            msg.setCc(this.mailSettings.getCc());
            msg.setSubject(report.hasError() ? this.mailSettings.getErrorSubject() : this.mailSettings.getSuccessSubject());
            String mailText = report.generateMessage();
            msg.setText(mailText);
            LOG.info((Object)("Sending report mail: " + msg));
            this.mailSender.send(msg);
            LOG.info((Object)"Report mail successfully sent!");
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot send report mail", (Throwable)e);
        }
    }

    private MimeMessage buildMimeMessage(Report report) {
        MimeMessage message = new MimeMessage(this.mailSession());
        MimeMessageHelper helper = null;
        try {
            helper = new MimeMessageHelper(message, true, "UTF-8");
            helper.setFrom(this.mailSettings.getFrom());
            helper.setTo(this.mailSettings.getTo());
            helper.setCc(this.mailSettings.getCc());
            helper.setSubject(report.hasError() ? this.mailSettings.getErrorSubject() : this.mailSettings.getSuccessSubject());
            String msg = report.generateMessage();
            LOG.info((Object)("Mail text: " + msg));
            helper.setText(msg);
        }
        catch (Exception e) {
            throw new RuntimeException("Building mime message failed", e);
        }
        return message;
    }

    private PublicClientApplication publicClientApplication() throws MalformedURLException {
        return ((PublicClientApplication.Builder)PublicClientApplication.builder((String)this.mailSettings.getApplicationid()).authority(this.mailSettings.getAuthendpoint())).build();
    }

    private String tokenForSMTP(String userName, String accessToken) {
        String ctrlA = Character.toString('\u0001');
        String coded = "user=" + userName + ctrlA + "auth=Bearer " + accessToken + ctrlA + ctrlA;
        return Base64.getEncoder().encodeToString(coded.getBytes());
    }

    private Session mailSession() {
        Properties props = new Properties();
        props.put("mail.smtp.auth.xoauth2.disable", "false");
        props.put("mail.smtp.sasl.enable", "true");
        props.put("mail.imap.auth.mechanisms", "XOAUTH2");
        props.put("mail.smtp.auth.mechanisms", "XOAUTH2");
        props.put("mail.smtp.port", this.mailSettings.getPort());
        props.put("mail.smtp.starttls.enable", "true");
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.smtp.host", this.mailSettings.getHost());
        return Session.getInstance((Properties)props);
    }
}

