/*
 * Decompiled with CFR 0.152.
 */
package de.perview.sp.schedulers;

import de.perview.sp.CommonUtils;
import de.perview.sp.LastRunHolder;
import de.perview.sp.SimpleCsvMapper;
import de.perview.sp.api.PersonExportActionFailedDto;
import de.perview.sp.api.PersonIdentityDto;
import de.perview.sp.api.PersonUpdatedFieldDto;
import de.perview.sp.api.PersonValidator;
import de.perview.sp.api.PerviewApi;
import de.perview.sp.api.PerviewApiClient;
import de.perview.sp.api.PerviewApiSettings;
import de.perview.sp.api.SPDataApiClient;
import de.perview.sp.api.SPDataCreateApi;
import de.perview.sp.dto.PersonDto;
import de.perview.sp.mail.ExportToSPDataReport;
import de.perview.sp.mail.MailReportSender;
import de.perview.sp.mail.Report;
import de.perview.sp.schedulers.SPDataUtils;
import generated.Mitarbeiter.Daten;
import generated.Mitarbeiter.MandantTyp;
import generated.Mitarbeiter.StatusListeTyp;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class ExportFromPerviewToSPDataScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(ExportFromPerviewToSPDataScheduler.class);
    @Autowired
    private LastRunHolder lastRunHolder;
    @Autowired
    private SPDataCreateApi spDataCreateApi;
    @Autowired
    private PerviewApi perviewApi;
    @Autowired
    private PerviewApiSettings perviewApiSettings;
    @Autowired
    private PerviewApiClient perviewApiClient;
    @Autowired
    private SPDataUtils sPUtils;
    @Autowired
    private PersonValidator validator;
    @Autowired
    private MailReportSender mail;
    @Autowired
    private SPDataApiClient sPDataApiClient;
    @Autowired
    private CommonUtils commonUtils;
    @Autowired
    private SimpleCsvMapper simpleCsvMapper;
    @Value(value="${customFieldKeySyncId:syncId}")
    private String customFieldKeySyncId;
    @Value(value="${customFieldKeyMandantennummer:Mandantennummer}")
    private String customFieldMandantennummer;
    @Value(value="${customFieldKeyMandantenId:MandantenId}")
    private String customFieldMandantenId;
    @Value(value="${perviewPersonIdsNotYetExportedFilePath:}")
    private String perviewPersonIdsNotYetExportedFilePath;
    @Value(value="${export.schedule.cron.enabled:false}")
    private boolean scheduleEnabled;
    @Value(value="${runExportOnStartup:false}")
    private boolean runExportOnStartup;
    @Value(value="${updateLastExportTimestampOnSuccess:true}")
    private boolean updateLastExportTimestampOnSuccess;
    @Value(value="${fillEmptySyncIdBeforePostCreate:true}")
    private boolean fillEmptySyncIdBeforePostCreate;
    @Value(value="${checkAndUpdateSyncIdFromSpdataAfterCreate:true}")
    private boolean checkAndUpdateSyncIdFromSpdataAfterCreate;
    @Value(value="${checkAndUpdateMandatorFromSpdataAfterCreate:true}")
    private boolean checkAndUpdateMandatorFromSpdataAfterCreate;
    @Value(value="${fetchAndLogEmployeeFromSpDataAfterUpdateOrCreate:false}")
    private boolean fetchAndLogEmployeeFromSpDataAfterUpdateOrCreate;
    private int createdEmployees = 0;
    private int updatedEmployees = 0;
    private int totalExports = 0;
    private int currentExport = 0;
    ExportToSPDataReport exportReport = new ExportToSPDataReport();
    Set<PersonDto> personsNotExportedNow;

    @EventListener(value={ApplicationReadyEvent.class})
    public void onApplicationReady() {
        if (this.runExportOnStartup) {
            this.exportFromPerviewToSPData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="${export.schedule.cron}")
    public synchronized void exportFromPerviewToSPData() {
        if (!this.scheduleEnabled) {
            return;
        }
        long start = System.currentTimeMillis();
        try {
            LOG.info("Start export of created or updated employees from perview to SP-Data");
            PersonDto.customFieldKeySyncId = this.customFieldKeySyncId;
            PersonDto.customFieldKeyMandantennummer = this.customFieldMandantennummer;
            PersonDto.customFieldKeyMandantenId = this.customFieldMandantenId;
            LOG.info("scheduleEnabled=" + this.scheduleEnabled);
            LOG.info("runExportOnStartup=" + this.runExportOnStartup);
            LOG.info("fetchChangesWithSingleApiCall=" + this.perviewApiSettings.fetchChangesWithSingleApiCall);
            LOG.info("updateLastExportTimestampOnSuccess=" + this.updateLastExportTimestampOnSuccess);
            LOG.info("fillEmptySyncIdBeforePostCreate=" + this.fillEmptySyncIdBeforePostCreate);
            LOG.info("checkAndUpdateSyncIdFromSpdataAfterCreate=" + this.checkAndUpdateSyncIdFromSpdataAfterCreate);
            LOG.info("checkAndUpdateMandatorFromSpdataAfterCreate=" + this.checkAndUpdateMandatorFromSpdataAfterCreate);
            LOG.info("fetchAndLogEmployeeFromSpDataAfterUpdateOrCreate=" + this.fetchAndLogEmployeeFromSpDataAfterUpdateOrCreate);
            List existingPerviewPersons = this.perviewApiClient.fetchExistingActivePerviewPersons();
            HashMap<String, PersonDto> perviewPersonsById = new HashMap<String, PersonDto>();
            for (PersonDto p : existingPerviewPersons) {
                String id = p.getId();
                if (StringUtils.hasText((String)id)) {
                    perviewPersonsById.put(id, p);
                    continue;
                }
                LOG.warn("person has no id (person skipped): " + p.getNameAndIds());
            }
            Date lastExportDate = this.lastRunHolder.getLastExportTimestamp();
            LOG.info("lastExportDate=" + this.commonUtils.getFormattedDate(lastExportDate, "yyyy-MM-dd_HH:mm:ss"));
            Date currentExportDate = new Date();
            LOG.info("currentExportDate=" + this.commonUtils.getFormattedDate(currentExportDate, "yyyy-MM-dd_HH:mm:ss"));
            this.exportReport.setSince(lastExportDate);
            this.exportReport.setUntil(currentExportDate);
            HashMap spdataMitarbeiterBySyncId = new HashMap();
            TreeSet perviewPersonsForCreateInSpdata = new TreeSet();
            TreeSet perviewPersonsForUpdateInSpdata = new TreeSet();
            List createdPerviewPersons = this.fetchCreatedPerviewPersons(perviewPersonsById, lastExportDate, currentExportDate);
            LOG.info("createdPerviewPersons=" + createdPerviewPersons.size());
            this.fetchMatchingSpdataEmployeesBySyncId(createdPerviewPersons, perviewPersonsForCreateInSpdata, perviewPersonsForUpdateInSpdata, spdataMitarbeiterBySyncId);
            LOG.info("Matching spdata employees for created persons by syncId: " + spdataMitarbeiterBySyncId.size());
            Map changesMap = this.fetchPersonChanges(existingPerviewPersons, lastExportDate, currentExportDate);
            for (Object personDto : createdPerviewPersons) {
                if (!changesMap.containsKey(personDto.getId())) continue;
                changesMap.remove(personDto.getId());
            }
            ArrayList<PersonDto> updatedPerviewPersons = new ArrayList<PersonDto>();
            for (String id : changesMap.keySet()) {
                PersonDto p = (PersonDto)perviewPersonsById.get(id);
                if (updatedPerviewPersons.contains(p)) continue;
                updatedPerviewPersons.add(p);
            }
            LOG.info("updatedPerviewPersons=" + updatedPerviewPersons.size());
            this.fetchMatchingSpdataEmployeesBySyncId(updatedPerviewPersons, perviewPersonsForCreateInSpdata, perviewPersonsForUpdateInSpdata, spdataMitarbeiterBySyncId);
            LOG.info("Matching spdata employees for created and updated persons by syncId: " + spdataMitarbeiterBySyncId.size());
            Set perviewPersonsNotYetExported = this.loadPersonsNotYetExported(this.perviewPersonIdsNotYetExportedFilePath, existingPerviewPersons, perviewPersonsById);
            ArrayList<PersonDto> personsNotYetExported = new ArrayList<PersonDto>();
            for (PersonExportActionFailedDto dto : perviewPersonsNotYetExported) {
                PersonDto p = dto.getPersonDto();
                if (personsNotYetExported.contains(p)) continue;
                personsNotYetExported.add(p);
            }
            this.fetchMatchingSpdataEmployeesBySyncId(personsNotYetExported, perviewPersonsForCreateInSpdata, perviewPersonsForUpdateInSpdata, spdataMitarbeiterBySyncId);
            LOG.info("Matching spdata employees for created, updated and not yet exported persons by syncId: " + spdataMitarbeiterBySyncId.size());
            LOG.info("perviewPersonsForCreateInSpdata=" + perviewPersonsForCreateInSpdata.size());
            LOG.info("perviewPersonsForUpdateInSpdata=" + perviewPersonsForUpdateInSpdata.size());
            this.totalExports = perviewPersonsForCreateInSpdata.size() + perviewPersonsForUpdateInSpdata.size();
            LOG.info("Total persons to export: {}", (Object)this.totalExports);
            this.preparePerviewPersonsForPostOrUpdate(perviewPersonsForCreateInSpdata, spdataMitarbeiterBySyncId);
            this.preparePerviewPersonsForPostOrUpdate(perviewPersonsForUpdateInSpdata, spdataMitarbeiterBySyncId);
            this.currentExport = 0;
            this.createdEmployees = 0;
            this.updatedEmployees = 0;
            this.personsNotExportedNow = new TreeSet<PersonDto>(Comparator.comparing(PersonDto::getId, (s1, s2) -> s1.compareTo((String)s2)));
            if (!perviewPersonsForCreateInSpdata.isEmpty()) {
                this.createOrUpdateSpdataEmployees(perviewPersonsForCreateInSpdata, spdataMitarbeiterBySyncId, true, this.exportReport);
            }
            if (!perviewPersonsForUpdateInSpdata.isEmpty()) {
                this.createOrUpdateSpdataEmployees(perviewPersonsForUpdateInSpdata, spdataMitarbeiterBySyncId, false, this.exportReport);
            }
            this.exportReport.setFailedPersonsCount(this.totalExports - this.createdEmployees - this.updatedEmployees);
            this.exportReport.setUnchangedCount(perviewPersonsById.size() - this.totalExports);
            this.savePerviewPersonsNotExportedNow(perviewPersonsNotYetExported, this.personsNotExportedNow, this.perviewPersonIdsNotYetExportedFilePath, lastExportDate, currentExportDate);
            if (this.updateLastExportTimestampOnSuccess) {
                this.lastRunHolder.updateLastExportTimestamp(currentExportDate);
            }
            long end = System.currentTimeMillis();
            this.exportReport.setElapsedMinutes(this.getElapsedMinutes(start, end));
            this.mail.send((Report)this.exportReport);
            LOG.info("Finished export of created or updated employees from perview to SP-Data");
        }
        catch (Exception e) {
            this.exportReport.addError(this.commonUtils.getExceptionDetails((Throwable)e));
            long end = System.currentTimeMillis();
            this.exportReport.setElapsedMinutes(this.getElapsedMinutes(start, end));
            this.mail.send((Report)this.exportReport);
            LOG.error("Export of employees created or updated from perview to SP-Data failed:", (Throwable)e);
        }
        finally {
            long end = System.currentTimeMillis();
            LOG.info("Elapsed minutes: " + this.getElapsedMinutes(start, end));
        }
    }

    private void fetchMatchingSpdataEmployeesBySyncId(List<PersonDto> perviewPersons, Set<PersonDto> perviewPersonsForCreate, Set<PersonDto> perviewPersonsForUpdate, Map<String, Daten.Mitarbeiter> spdataMitarbeiterBySyncId) {
        try {
            LOG.info("Fetch matching spdata employees by syncId, perviewPersons=" + perviewPersons.size() + " ...");
            if (this.fillEmptySyncIdBeforePostCreate) {
                LOG.info("fillEmptySyncIdBeforePostCreate=" + this.fillEmptySyncIdBeforePostCreate);
                LOG.info("==> Spdata employees will be searched by person id as syncId for perview persons having no syncId");
            }
            int perviewPersonsHavingNoSyncId = 0;
            int perviewPersonsMatchedByIdAsSyncId = 0;
            for (PersonDto p : perviewPersons) {
                Daten.Mitarbeiter m;
                String syncId = p.getSyncId();
                if (!StringUtils.hasText((String)syncId)) {
                    if (this.fillEmptySyncIdBeforePostCreate) {
                        syncId = p.getId();
                    }
                    ++perviewPersonsHavingNoSyncId;
                }
                if ((m = this.sPDataApiClient.fetchSpDataMitarbeiterBySyncid(p)) != null) {
                    LOG.info("Employee found");
                    spdataMitarbeiterBySyncId.put(m.getSyncid(), m);
                    perviewPersonsForUpdate.add(p);
                    if (StringUtils.hasText((String)p.getSyncId())) continue;
                    ++perviewPersonsMatchedByIdAsSyncId;
                    continue;
                }
                LOG.info("Employee not found");
                perviewPersonsForCreate.add(p);
            }
            if (this.fillEmptySyncIdBeforePostCreate) {
                LOG.info("Spdata employees searched by person id as syncId for perview persons having no syncId: " + perviewPersonsHavingNoSyncId);
                LOG.info("Spdata employees matched by person id as syncId: " + perviewPersonsMatchedByIdAsSyncId);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("fetchMatchingSpdataEmployeesBySyncId failed", e);
        }
    }

    private void preparePerviewPersonsForPostOrUpdate(Set<PersonDto> perviewPersons, Map<String, Daten.Mitarbeiter> spdataMitarbeiterBySyncId) {
        LOG.info("preparePerviewPersonsForPostOrUpdate: ");
        try {
            for (PersonDto p : perviewPersons) {
                Daten.Mitarbeiter m;
                String syncId = p.getSyncId();
                if (this.fillEmptySyncIdBeforePostCreate && !StringUtils.hasText((String)syncId)) {
                    syncId = p.getId();
                    this.setSyncIdIdInPerview(p, syncId);
                }
                if ((m = spdataMitarbeiterBySyncId.get(syncId)) == null) continue;
                PersonDto spdataPerson = new PersonDto(m);
                this.checkAndFixIdentcodeAndSyncIdInPerview(p, spdataPerson);
            }
            LOG.info("preparePerviewPersonsForPostOrUpdate: Done");
        }
        catch (Exception e) {
            throw new RuntimeException("preparePerviewPersonsForPostOrUpdate failed");
        }
    }

    private void setSyncIdIdInPerview(PersonDto person, String syncId) {
        LOG.info("setSyncIdIdInPerview: person=" + person.getNameAndIds() + ", syncId=" + syncId);
        try {
            person.setSyncId(syncId);
            this.perviewApiClient.updatePerviewPerson(person);
            LOG.info("setSyncIdIdInPerview: Done");
        }
        catch (Exception e) {
            throw new RuntimeException("setSyncIdIdInPerview failed: person=" + person.getNameAndIds() + ", syncId=" + syncId);
        }
    }

    private void checkAndFixIdentcodeAndSyncIdInPerview(PersonDto perviewPerson, PersonDto spdataPerson) {
        try {
            boolean sendUpdateToPerview = false;
            String perviewIdentcode = perviewPerson.getIdentcode();
            String spDataIdentcode = Optional.ofNullable(spdataPerson.getIdentcode()).orElse("");
            if (StringUtils.hasText((String)spDataIdentcode) && !spDataIdentcode.equals(perviewIdentcode)) {
                perviewPerson.setIdentcode(spDataIdentcode);
                sendUpdateToPerview = true;
                LOG.info("checkAndFixIdentcodeAndSyncIdInPerview: perviewPerson=" + perviewPerson.getNameAndIds() + ", perviewIdentcode " + perviewIdentcode + " --> " + spDataIdentcode);
            }
            if (this.fillEmptySyncIdBeforePostCreate && !StringUtils.hasText((String)perviewPerson.getSyncId())) {
                perviewPerson.setSyncId(perviewPerson.getId());
                sendUpdateToPerview = true;
                LOG.info("checkAndFixIdentcodeAndSyncIdInPerview: " + perviewPerson.getNameAndIds() + " ==> set empty syncId by id: " + perviewPerson.getId());
            }
            if (sendUpdateToPerview) {
                this.perviewApiClient.updatePerviewPerson(perviewPerson);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("checkAndFixIdentcodeAndSyncIdInPerview failed: perviewPerson=" + perviewPerson.getNameAndIds() + ", spdataPerson=" + spdataPerson.getNameAndIds());
        }
    }

    private void createOrUpdateSpdataEmployees(Set<PersonDto> persons, Map<String, Daten.Mitarbeiter> spdataMitarbeiterBySyncId, boolean create, ExportToSPDataReport exportReport) {
        try {
            for (PersonDto p : persons) {
                Daten.Mitarbeiter m = spdataMitarbeiterBySyncId.get(p.getSyncId());
                if (create) {
                    if (m == null) {
                        m = new Daten.Mitarbeiter();
                        String syncId = p.getSyncId();
                        if (this.fillEmptySyncIdBeforePostCreate && !StringUtils.hasText((String)syncId)) {
                            syncId = p.getId();
                        }
                        m.setSyncid(syncId);
                    } else {
                        throw new RuntimeException("createOrUpdateSpdataEmployees: create && m != null: This should not occur because existence checked before! person=" + p.getNameAndAllIds());
                    }
                }
                m = this.sPUtils.buildSpdataEmployee(m, p, this.validator.getValidDto(), create);
                Daten spData = new Daten();
                spData.setVersion(BigInteger.ONE);
                spData.getMitarbeiter().add(m);
                boolean success = this.createOrUpdateSpdataEmployee(spData, p, create);
                if (success) {
                    if (create) {
                        ++this.createdEmployees;
                        exportReport.addCreatedPerson(p);
                    } else {
                        ++this.updatedEmployees;
                        exportReport.addUpdatedPerson(p);
                    }
                    if (!this.fetchAndLogEmployeeFromSpDataAfterUpdateOrCreate) continue;
                    this.fetchAndLogEmployeeFromSpData(p, create);
                    continue;
                }
                exportReport.incrementFailedPersonsCount();
                this.personsNotExportedNow.add(p);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("createOrUpdateSpdataEmployees failed: ", e);
        }
    }

    private void fetchAndLogEmployeeFromSpData(PersonDto person, boolean created) {
        LOG.info("fetchAndLogEmployeeFromSpData: syncId=" + person.getSyncId());
        try {
            Daten.Mitarbeiter employee = this.sPDataApiClient.fetchSpDataMitarbeiterBySyncid(person);
            String mode = created ? "Created" : "Updated";
            LOG.info("fetchAndLogEmployeeFromSpData: " + mode + " employee=" + SPDataUtils.getAsString((Daten.Mitarbeiter)employee));
        }
        catch (Exception e) {
            LOG.warn("fetchAndLogEmployeeFromSpData failed (ignored, no problem)", (Throwable)e);
        }
    }

    private boolean createOrUpdateSpdataEmployee(Daten spData, PersonDto person, boolean create) {
        String spdataRequest = SPDataUtils.getAsString((Daten)spData);
        LOG.info("createOrUpdateSpdataEmployee: Export employee {}/{} to SP-Data: person=" + person.getNameAndIds() + ", create=" + create, (Object)(++this.currentExport), (Object)this.totalExports);
        Daten response = null;
        String spdataResponse = "";
        StringBuilder errorResponse = new StringBuilder();
        try {
            response = create ? this.spDataCreateApi.sendMitarbeiter(spData) : this.spDataCreateApi.updateMitarbeiter(spData);
            spdataResponse = SPDataUtils.getAsString((Daten)response);
            List employeesReturned = response.getMitarbeiter();
            LOG.debug("createOrUpdateSpdataEmployee: response=" + spdataResponse);
            LOG.debug("createOrUpdateSpdataEmployee: employeesReturned=" + employeesReturned.size());
            if (employeesReturned.isEmpty()) {
                if (create && person.getSyncId() == null) {
                    throw new RuntimeException("No syncId on create provided and no employee returned from spdata to fetch syncId from!");
                }
            } else if (employeesReturned.size() == 1) {
                Daten.Mitarbeiter m = (Daten.Mitarbeiter)employeesReturned.get(0);
                if (m.getStatusListe() == null) {
                    if (create && person.getSyncId() == null) {
                        this.updateSyncIdAndMandantenNummerInPerview(person, m);
                    }
                } else {
                    for (StatusListeTyp.Status s : m.getStatusListe().getStatus()) {
                        String category;
                        int type = s.getTyp().intValue();
                        if (type == 1) {
                            category = "Hinweis";
                            LOG.info("Typ: {}, Feld: {}, {}: {}", new Object[]{type, s.getFeld(), category, s.getMeldung()});
                        } else if (type == 2) {
                            category = "Warnung";
                            LOG.warn("Typ: {}, Feld: {}, {}: {}", new Object[]{type, s.getFeld(), category, s.getMeldung()});
                        } else if (type == 3) {
                            category = "Fehler";
                            LOG.error("Typ: {}, Feld: {}, {}: {}", new Object[]{type, s.getFeld(), category, s.getMeldung()});
                            this.exportReport.buildErrorResponse(create, errorResponse, category, person, m, s, response.getVorgangid());
                        } else {
                            category = "Unbekannter Fehler";
                            LOG.error("Typ: {}, Feld: {}, {}: {}", new Object[]{type, s.getFeld(), category, s.getMeldung()});
                            this.exportReport.buildErrorResponse(create, errorResponse, category, person, m, s, response.getVorgangid());
                        }
                        this.exportReport.addErrorResponse(create, category, person, m, s, response.getVorgangid());
                    }
                }
            } else {
                throw new RuntimeException("Spdata reported more than one employee created or updated: " + employeesReturned.size());
            }
            if (StringUtils.hasText((CharSequence)errorResponse)) {
                LOG.error("createOrUpdateSpdataEmployee: " + String.format("Export of person %s failed: %s%n", person.getNameAndIds(), errorResponse.toString()));
                return false;
            }
            LOG.info("createOrUpdateSpdataEmployee: Person successful exported");
            return true;
        }
        catch (Exception e) {
            LOG.error("Export employee {}/{} to SP-Data failed: person=" + person.getNameAndAllIds() + ", create=" + create, new Object[]{this.currentExport, this.totalExports, e});
            errorResponse.append(String.format("%nExport of person %s failed: %s%n", person.getNameAndIds(), this.commonUtils.getExceptionDetails((Throwable)e)));
            errorResponse.append(String.format("%nperson: %s%n", this.commonUtils.pretty((Object)person)));
            errorResponse.append(String.format("%nspdataRequest: %s%n", spdataRequest));
            errorResponse.append(String.format("%nspdataResponse: %s%n", spdataResponse));
            this.exportReport.addError(create, errorResponse.toString());
            return false;
        }
    }

    private void updateSyncIdAndMandantenNummerInPerview(PersonDto p, Daten.Mitarbeiter m) {
        LOG.info("updateSyncIdAndMandantenNummerInPerview: person=" + p.getNameAndAllIds() + " ==> syncId from spdata: " + m.getSyncid());
        p.setSyncId(m.getSyncid());
        String mandatorNr = "";
        String mandatorId = "";
        MandantTyp typ = SPDataUtils.getCurrentMandator((Daten.Mitarbeiter)m);
        if (typ != null && typ.getId() != null && typ.getNummer() != null) {
            mandatorNr = typ.getNummer();
            mandatorId = typ.getId().toString();
        }
        if (StringUtils.hasText((String)mandatorNr) && !mandatorNr.equals(p.getMandantennummer())) {
            LOG.warn("Mandantennummer changed after exporting new perview person: person=" + p.getNameAndIds() + "mandantennummer: " + p.getMandantennummer() + " --> " + mandatorNr);
        } else {
            mandatorNr = p.getMandantennummer();
            mandatorId = p.getMandantenId();
        }
        String identcode = m.getPersonalnr();
        this.perviewApiClient.updateMandatorAndIdentcodeInPerview(p, mandatorNr, identcode, mandatorId);
    }

    private int getElapsedMinutes(long startMillis, long endMillis) {
        long difference = endMillis - startMillis;
        return (int)(difference / 60000L % 60L);
    }

    private List<PersonDto> fetchCreatedPerviewPersons(Map<String, PersonDto> perviewPersonsById, Date since, Date until) {
        try {
            LOG.info("Fetching perview persons created since: " + this.commonUtils.getFormattedDate(since, "yyyy-MM-dd_HH:mm:ss") + " ...");
            ArrayList<PersonDto> createdPerviewPersons = new ArrayList<PersonDto>();
            List dtos = this.perviewApi.getCreatedPersons(since, until);
            LOG.info("dtos=" + dtos.size());
            for (PersonIdentityDto dto : dtos) {
                String id = dto.getTransferId();
                PersonDto person = perviewPersonsById.get(id);
                if (person != null) {
                    createdPerviewPersons.add(person);
                    continue;
                }
                LOG.warn("Created person not found in perviewPersonsById (Maybe deleted?): transferId=" + dto.getTransferId());
            }
            return createdPerviewPersons;
        }
        catch (Exception e) {
            throw new RuntimeException("fetchCreatedPerviewPersons failed", e);
        }
    }

    private Map<String, List<PersonUpdatedFieldDto>> fetchPersonChanges(List<PersonDto> persons, Date since, Date until) {
        try {
            LOG.info("Fetching perview person changes since: " + this.commonUtils.getFormattedDate(since, "yyyy-MM-dd_HH:mm:ss") + " ...");
            TreeMap<String, List<PersonUpdatedFieldDto>> personsChangesMap = new TreeMap<String, List<PersonUpdatedFieldDto>>();
            if (this.perviewApiSettings.fetchChangesWithSingleApiCall) {
                HashSet<String> personIds = new HashSet<String>();
                for (PersonDto personDto : persons) {
                    personIds.add(personDto.getId());
                }
                List allUpdates = this.perviewApi.getPersonsUpdatedFields(since, until);
                for (PersonUpdatedFieldDto update : allUpdates) {
                    List updates;
                    String transferId = update.getTransferId();
                    if (!personIds.contains(transferId)) continue;
                    if (!personsChangesMap.containsKey(transferId)) {
                        personsChangesMap.put(transferId, new ArrayList());
                    }
                    if ((updates = (List)personsChangesMap.get(transferId)).contains(update)) continue;
                    updates.add(update);
                }
            } else {
                for (PersonDto personDto : persons) {
                    String string = personDto.getId();
                    List updates = this.perviewApi.getPersonsUpdatedFields(string, since, until);
                    if (updates.isEmpty()) continue;
                    personsChangesMap.put(string, updates);
                }
            }
            return personsChangesMap;
        }
        catch (Exception e) {
            throw new RuntimeException("fetchPersonChanges failed", e);
        }
    }

    private Set<PersonExportActionFailedDto> loadPersonsNotYetExported(String filePath, List<PersonDto> persons, Map<String, PersonDto> personsById) {
        LOG.info("loadPersonsNotYetExported: filePath=" + filePath);
        TreeSet<PersonExportActionFailedDto> result = new TreeSet<PersonExportActionFailedDto>();
        File file = new File(filePath);
        if (file.exists()) {
            LOG.info("loadPersonsNotYetExported: File found, loading...");
            List dtos = this.simpleCsvMapper.readFromCsv(filePath, PersonExportActionFailedDto.class);
            for (PersonExportActionFailedDto dto : dtos) {
                String id = dto.getId();
                PersonDto person = personsById.get(id);
                if (person != null) {
                    dto.setPersonDto(person);
                    result.add(dto);
                    continue;
                }
                LOG.error("loadPersonsNotYetExported: person not found  (skipped): " + id);
            }
        } else {
            LOG.info("loadPersonsNotYetExported: File not found (ignored)");
        }
        LOG.info("loadPersonsNotYetExported: Loaded perviewPersonsNotYetExported=" + this.commonUtils.pretty(result));
        return result;
    }

    private void savePerviewPersonsNotExportedNow(Set<PersonExportActionFailedDto> personsExportActionFailed, Set<PersonDto> personsExportActionFailedNow, String filePath, Date lastExportDate, Date currentExportDate) {
        LOG.info("savePerviewPersonsNotExportedNow: filePath=" + filePath);
        ArrayList<PersonExportActionFailedDto> personsExportActionFailedList = new ArrayList<PersonExportActionFailedDto>(personsExportActionFailed);
        ArrayList<PersonExportActionFailedDto> dtos = new ArrayList<PersonExportActionFailedDto>();
        for (PersonDto p : personsExportActionFailedNow) {
            PersonExportActionFailedDto dto = new PersonExportActionFailedDto(p.getId(), lastExportDate, currentExportDate);
            if (personsExportActionFailed.contains(dto)) {
                int index = personsExportActionFailedList.indexOf(dto);
                dto = (PersonExportActionFailedDto)personsExportActionFailedList.get(index);
                LOG.info("savePerviewPersonsNotExportedNow: kept: " + dto);
            } else {
                LOG.info("savePerviewPersonsNotExportedNow: added: " + dto);
            }
            dtos.add(dto);
        }
        LOG.info("savePerviewPersonsNotExportedNow: dtos to write=" + this.commonUtils.pretty(dtos));
        this.simpleCsvMapper.writeToCsv(filePath, PersonExportActionFailedDto.class, dtos);
        LOG.info("savePerviewPersonsNotExportedNow: Done");
    }
}

