/*
 * Decompiled with CFR 0.152.
 */
package de.perview.sp.schedulers;

import de.perview.sp.api.PerviewApi;
import de.perview.sp.api.PerviewApiClient;
import de.perview.sp.api.SPDataReadApi;
import de.perview.sp.dto.AddressDto;
import de.perview.sp.dto.PersonDto;
import de.perview.sp.mail.ImportToPerviewReport;
import de.perview.sp.schedulers.SPDataUtils;
import generated.Mitarbeiter.Daten;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="sync.persons")
public class SyncPersonsScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(SyncPersonsScheduler.class);
    private static SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
    @Autowired
    private SPDataReadApi spDataReadApi;
    @Autowired
    private PerviewApi perviewApi;
    @Autowired
    private PerviewApiClient perviewApiClient;
    private ImportToPerviewReport importReport = new ImportToPerviewReport();
    private Map<String, PersonDto> personsByIdentcode;
    private Map<String, PersonDto> personsByNameAndBirthdate;
    private Map<String, PersonDto> employeesByNameAndBirthdate;
    @Value(value="${onlyReport:true}")
    private Boolean onlyReport;
    @Value(value="${loadSpdataFromFile:false}")
    private boolean loadSpdataFromFile;
    @Value(value="${spdataImportXmlFileIn}")
    private String spdataImportXmlFileIn;
    @Value(value="${spdataImportXmlFileOut}")
    private String spdataImportXmlFileOut;
    @Value(value="${csvReportFile}")
    private String csvReportFile;
    @Value(value="${sqlReportFile}")
    private String sqlReportFile;
    private int matchedPersonsByIdentcode;
    private int matchedPersonsByNameAndBirthdate;
    private int notMatchedEmployees;
    @Value(value="${customFieldKeySyncId:syncId}")
    private String customFieldKeySyncId;
    @Value(value="${customFieldKeyMandantennummer:Mandantennummer}")
    private String customFieldMandantennummer;
    @Value(value="${customFieldKeyMandantenId:MandantenId}")
    private String customFieldMandantenId;
    @Value(value="${sync.persons.schedule.enabled:false}")
    private boolean scheduleEnabled;

    @Scheduled(cron="${sync.persons.schedule.cron}")
    public void synchronizePersons() {
        if (!this.scheduleEnabled) {
            return;
        }
        try {
            LOG.info("onlyReport=" + this.onlyReport);
            LOG.info("reportFile=" + this.csvReportFile);
            LOG.info("loadSpdataFromFile=" + this.loadSpdataFromFile);
            LOG.info("spdataImportXmlFileIn=" + this.spdataImportXmlFileIn);
            LOG.info("spdataImportXmlFileOut=" + this.spdataImportXmlFileOut);
            PersonDto.customFieldKeySyncId = this.customFieldKeySyncId;
            PersonDto.customFieldKeyMandantennummer = this.customFieldMandantennummer;
            PersonDto.customFieldKeyMandantenId = this.customFieldMandantenId;
            LOG.info("customFieldKeyDatevMandator=" + this.customFieldKeySyncId);
            List existingPerviewPersons = this.perviewApiClient.fetchExistingActivePerviewPersons();
            Daten spData = null;
            if (this.loadSpdataFromFile) {
                LOG.info("Retrieving employees from file: " + this.spdataImportXmlFileIn);
                spData = SPDataUtils.readSpDataFromFile((String)this.spdataImportXmlFileIn);
            } else {
                LOG.info("Retrieving employees from SP-Data...");
                spData = this.spDataReadApi.getMitarbeiter();
                LOG.info("Writing spData xml to file: " + this.spdataImportXmlFileOut);
                SPDataUtils.writeSpDataToFile((Daten)spData, (String)this.spdataImportXmlFileOut);
            }
            List employees = spData.getMitarbeiter();
            LOG.info("Retrieved employees: {} ", (Object)employees.size());
            List employeesToPerview = employees.stream().map(PersonDto::new).collect(Collectors.toList());
            this.synchronizePersons(existingPerviewPersons, employeesToPerview);
        }
        catch (Exception ex) {
            LOG.error("Synchronizing SP-Data employees and perview persons failed", (Throwable)ex);
            this.importReport.addError(ex.getMessage());
        }
    }

    public void synchronizePersons(List<PersonDto> perviewPeople, List<PersonDto> employeesToPerview) {
        this.buildMaps(perviewPeople, employeesToPerview);
        this.generateReportFile(perviewPeople, employeesToPerview);
        if (this.onlyReport.booleanValue()) {
            return;
        }
        LOG.info("Start synchronizing SP-Data employees and perview persons");
        this.matchedPersonsByIdentcode = 0;
        this.matchedPersonsByNameAndBirthdate = 0;
        this.notMatchedEmployees = 0;
        for (PersonDto p : employeesToPerview) {
            try {
                boolean matchByIdentcode = true;
                PersonDto person = (PersonDto)this.personsByIdentcode.get(p.getIdentcode());
                if (person == null) {
                    matchByIdentcode = false;
                    person = (PersonDto)this.personsByNameAndBirthdate.get(this.getMatchKey(p));
                }
                if (person != null) {
                    String matchType;
                    String oldTransferId = person.getId();
                    String newTransferId = p.getId();
                    person.setId(newTransferId);
                    ResponseEntity response = this.perviewApi.sync(person, Boolean.valueOf(true));
                    if (HttpStatus.OK != response.getStatusCode()) {
                        throw new RuntimeException("API returned wrong status code: " + response.getStatusCodeValue() + ", person=" + person);
                    }
                    if (matchByIdentcode) {
                        matchType = "Match by identcode";
                        ++this.matchedPersonsByIdentcode;
                    } else {
                        matchType = "Match by name and birthdate";
                        ++this.matchedPersonsByNameAndBirthdate;
                    }
                    LOG.info("{}: Person {}-{} {}, birthdate: {} transferId was updated in perview: {} -> {}", new Object[]{matchType, p.getIdentcode(), p.getFirstname(), p.getLastname(), this.getBirthdate(p), oldTransferId, newTransferId});
                    continue;
                }
                ++this.notMatchedEmployees;
                LOG.info("SP-Data employee {}-{} {} {} has no match", new Object[]{p.getIdentcode(), p.getFirstname(), p.getLastname(), this.getBirthdate(p)});
            }
            catch (Exception e) {
                this.importReport.addError(p, e.getMessage());
                LOG.error("Person {}-{} {} could not be updated in perview", new Object[]{p.getIdentcode(), p.getFirstname(), p.getLastname(), e});
            }
        }
        LOG.info("Updated persons in perview (match by identcode): " + this.matchedPersonsByIdentcode);
        LOG.info("Updated persons in perview (match by name and birthdate): " + this.matchedPersonsByNameAndBirthdate);
        LOG.info("Not matched persons in perview: " + (perviewPeople.size() - this.matchedPersonsByIdentcode - this.matchedPersonsByNameAndBirthdate));
        LOG.info("Not matched employees in SP-Data: " + this.notMatchedEmployees);
        LOG.info("Finished synchronizing SP-Data employees and perview persons");
    }

    private void buildMaps(List<PersonDto> perviewPeople, List<PersonDto> employeesToPerview) {
        this.personsByIdentcode = new HashMap();
        this.personsByNameAndBirthdate = new TreeMap();
        for (PersonDto p : perviewPeople) {
            if (p.getIdentcode() != null) {
                this.personsByIdentcode.put(p.getIdentcode(), p);
            }
            this.personsByNameAndBirthdate.put(this.getMatchKey(p), p);
        }
        this.employeesByNameAndBirthdate = new TreeMap();
        for (PersonDto p : employeesToPerview) {
            this.employeesByNameAndBirthdate.put(this.getMatchKey(p), p);
        }
    }

    private void generateReportFile(List<PersonDto> perviewPeople, List<PersonDto> employeesToPerview) {
        LOG.info("Start generating report file");
        StringBuffer csvBuffer = new StringBuffer();
        StringBuilder sqlBuffer = new StringBuilder();
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        int matchedPersonsCount = 0;
        int personsOnlyInSpdataCount = 0;
        int personsOnlyInPerviewCount = 0;
        columns.add("SP-DATA");
        columns.add("Nachname");
        columns.add("Vorname");
        columns.add("Geburtsdatum");
        columns.add("Personalnummer");
        columns.add("SyncId");
        this.addMoreColumns(columns);
        columns.add("");
        columns.add("PERVIEW");
        columns.add("Nachname");
        columns.add("Vorname");
        columns.add("Geburtsdatum");
        columns.add("Personalnummer");
        columns.add("TransferId");
        this.addMoreColumns(columns);
        csvBuffer.append(this.getCsvRow(columns));
        for (PersonDto employee : employeesToPerview) {
            values.add("");
            this.addValues(employee, values);
            values.add("");
            PersonDto person = (PersonDto)this.personsByIdentcode.get(employee.getIdentcode());
            if (person == null) {
                person = (PersonDto)this.personsByNameAndBirthdate.get(this.getMatchKey(employee));
            }
            if (person != null) {
                values.add("");
                this.addValues(person, values);
                ++matchedPersonsCount;
                String mandantenNummerSql = String.format("INSERT INTO person_custom_field_data (field, person, data) VALUES (  (SELECT id FROM person_custom_field WHERE name = '" + this.customFieldMandantennummer + "'),   (SELECT id FROM person WHERE active=1 and transfer_id = '%s'),   '%s') ON DUPLICATE KEY UPDATE data = '%s';", person.getId(), employee.getMandantennummer(), employee.getMandantennummer());
                sqlBuffer.append(mandantenNummerSql).append("\n");
                String mandantenIdSql = String.format("INSERT INTO person_custom_field_data (field, person, data) VALUES (  (SELECT id FROM person_custom_field WHERE name = '" + this.customFieldMandantenId + "'),   (SELECT id FROM person WHERE active=1 and transfer_id = '%s'),   '%s') ON DUPLICATE KEY UPDATE data = '%s';", person.getId(), employee.getMandantenId(), employee.getMandantenId());
                sqlBuffer.append(mandantenIdSql).append("\n");
                String syncIdsql = String.format("INSERT INTO person_custom_field_data (field, person, data) VALUES (  (SELECT id FROM person_custom_field WHERE name = '" + this.customFieldKeySyncId + "'),   (SELECT id FROM person WHERE active=1 and transfer_id = '%s'),   '%s') ON DUPLICATE KEY UPDATE data = '%s';", person.getId(), employee.getSyncId(), employee.getSyncId());
                sqlBuffer.append(syncIdsql).append("\n");
            } else {
                values.add("");
                ++personsOnlyInSpdataCount;
            }
            csvBuffer.append(this.getCsvRow(values));
        }
        values.add("");
        csvBuffer.append(this.getCsvRow(values));
        for (PersonDto person : perviewPeople) {
            if (employeesToPerview.stream().anyMatch(e -> e.getIdentcode() != null && person.getIdentcode() != null && e.getIdentcode().equals(person.getIdentcode()))) continue;
            for (int i = 1; i <= 40; ++i) {
                values.add("");
            }
            this.addValues(person, values);
            ++personsOnlyInPerviewCount;
            csvBuffer.append(this.getCsvRow(values));
        }
        values.add("Matched count in Perview & Spdata");
        values.add("" + matchedPersonsCount);
        values.add("Count of persons in Spdata but not in Perview");
        values.add("" + personsOnlyInSpdataCount);
        values.add("Count of persons in Perview but not in Spdata");
        values.add("" + personsOnlyInPerviewCount);
        csvBuffer.append(this.getCsvRow(values));
        String employeeCsv = csvBuffer.toString();
        this.writeToFile(employeeCsv, this.csvReportFile);
        this.writeToFile(sqlBuffer.toString(), this.sqlReportFile);
        LOG.info("Finished generating report file");
    }

    private void addMoreColumns(ArrayList<String> columns) {
        columns.add("Mandator");
        columns.add("Title");
        columns.add("Sex");
        columns.add("Addon");
        columns.add("Country");
        columns.add("Street");
        columns.add("Town");
        columns.add("Zip");
        columns.add("BankAccountBankName");
        columns.add("BankAccountIban");
        columns.add("BankAccountBic");
        columns.add("PlaceOfBirth");
        columns.add("NameAtBirth");
        columns.add("Ssn");
        columns.add("Phone");
        columns.add("Mobile");
        columns.add("Fax");
        columns.add("Email");
        columns.add("PrivPhone");
        columns.add("PrivMobile");
        columns.add("PrivFax");
        columns.add("PrivEmail");
        columns.add("VacationDays");
        columns.add("Nationality");
        columns.add("TaxNumber");
        columns.add("Steuerklasse");
        columns.add("Denomination");
        columns.add("MaritalStatus");
        columns.add("NumberOfChildrens");
        columns.add("Entrydate");
        columns.add("CostCenters");
        columns.add("Hierarchyitem");
    }

    private void addValues(PersonDto person, ArrayList<String> values) {
        values.add(person.getLastname());
        values.add(person.getFirstname());
        values.add(this.getBirthdate(person));
        values.add(person.getIdentcode());
        values.add(person.getId());
        values.add((String)person.getCustomFields().get(this.customFieldKeySyncId));
        values.add(person.getTitle());
        values.add(person.getSex().name());
        AddressDto privateAddress = person.getPrivateAddress();
        values.add(privateAddress != null ? person.getPrivateAddress().getAddon() : "");
        values.add(privateAddress != null ? person.getPrivateAddress().getCountry() : "");
        values.add(privateAddress != null ? person.getPrivateAddress().getStreet() : "");
        values.add(privateAddress != null ? person.getPrivateAddress().getTown() : "");
        values.add(privateAddress != null ? person.getPrivateAddress().getZip() : "");
        values.add(person.getBankAccountBankName());
        values.add(person.getBankAccountIban());
        values.add(person.getBankAccountBic());
        values.add(person.getPlaceOfBirth());
        values.add(person.getNameAtBirth());
        values.add(person.getSsn());
        values.add(person.getPhone());
        values.add(person.getMobile());
        values.add(person.getFax());
        values.add(person.getEmail());
        values.add(person.getPrivPhone());
        values.add(person.getPrivMobile());
        values.add(person.getPrivFax());
        values.add(person.getPrivEmail());
        values.add("" + person.getVacationDays());
        values.add(person.getNationality());
        values.add(person.getTaxNumber());
        values.add("" + person.getTaxBracket());
        values.add("" + person.getDenomination());
        values.add("" + person.getMaritalStatus());
        values.add("" + person.getNumberOfChildrens());
        values.add(this.formatDate(person.getEntrydate()));
        values.add("" + person.getCostCenters());
        values.add(person.getHierarchyitem());
    }

    private String getCsvRow(ArrayList<String> values) {
        String csv = String.join((CharSequence)",", values.stream().map(s -> "\"" + s + "\"").collect(Collectors.toList())) + "\n";
        csv = csv.replaceAll("\"null\"", "\"\"");
        values.clear();
        return csv;
    }

    private void writeToFile(String csv, String file) {
        try {
            FileUtils.writeStringToFile((File)new File(file), (String)csv, (Charset)Charset.forName("UTF-8"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getMatchKey(PersonDto p) {
        String birthdate = p.getBirthdate() != null ? sdf.format(p.getBirthdate()) : "" + Math.random();
        return p.getLastname() + "#" + p.getFirstname() + "#" + birthdate;
    }

    private String getBirthdate(PersonDto p) {
        return this.formatDate(p.getBirthdate());
    }

    private String formatDate(Date date) {
        return date != null ? sdf.format(date) : "";
    }

    public int getMatchedPersonsByIdentcode() {
        return this.matchedPersonsByIdentcode;
    }

    public int getMatchedPersonsByNameAndBirthdate() {
        return this.matchedPersonsByNameAndBirthdate;
    }

    public int getNotMatchedEmployees() {
        return this.notMatchedEmployees;
    }

    public boolean isLoadSpdataFromFile() {
        return this.loadSpdataFromFile;
    }

    public void setLoadSpdataFromFile(boolean loadSpdataFromFile) {
        this.loadSpdataFromFile = loadSpdataFromFile;
    }
}

